/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NumberItemType
extends ItemType<NumberItemType> {
    private static final long serialVersionUID = 1L;
    protected final int allBits;
    private static final Long INIT_VAL = 0L;
    int \u5c0f\u6570\u90e8\u5206\u4f4d\u6570 = 0;
    long fenmu;
    private final Map<Long, String> valueNames = new HashMap<Long, String>();
    private String valueElseName = null;
    private final Map<Integer, BitsType> bitMap = new TreeMap<Integer, BitsType>();
    int \u663e\u793a\u8fdb\u5236 = 10;
    private Long defaultVal = INIT_VAL;
    private static final Function<Long, Long> NULL = Function.identity();
    private Function<Long, Long> decoder = NULL;
    private Function<Long, Long> encoder = NULL;

    public static NumberItemType BCD(int bytes, String name) {
        Function<Long, Long> decoder = a -> {
            long tmp = a;
            long ret = 0L;
            for (int i = 0; i < bytes * 2; ++i) {
                ret = ret * 10L + (tmp & 0xFL);
                tmp >>>= 4;
            }
            return ret;
        };
        Function<Long, Long> encoder = a -> {
            long tmp = a;
            long ret = 0L;
            for (int i = 0; i < bytes * 2; ++i) {
                ret = (ret << 4) + tmp % 10L;
                tmp /= 10L;
            }
            return ret;
        };
        return new NumberItemType(bytes, name).decoder(decoder, encoder);
    }

    public NumberItemType(int bytes, String name) {
        this(bytes, 0, name);
    }

    public NumberItemType(int bytes, int bits, String name) {
        super(name);
        this.allBits = bytes * 8 + bits;
        if (this.allBits > 504) {
            throw new IllegalArgumentException("\u7531\u4e8e\u4f4d\u64cd\u4f5c\u662f\u4ee54\u5b57\u8282\u7684int\u8fdb\u884c\uff0c\u6545\u6682\u4e0d\u652f\u6301\u5927\u4e8e4\u7684\u5b57\u8282\u6570:" + bytes);
        }
    }

    public int bytes() {
        return this.allBits / 8;
    }

    public int bits() {
        return this.allBits % 8;
    }

    public int allBits() {
        return this.allBits;
    }

    public NumberItemType valueNote(long val, String valueNote) {
        String old = this.valueNames.put(val, valueNote);
        if (old != null) {
            throw new IllegalArgumentException("key is repeated: " + val);
        }
        return this;
    }

    public NumberItemType valueElseNote(String valueNote) {
        this.valueElseName = valueNote;
        return this;
    }

    public NumberItemType valueNote(Map<Long, String> valueNames) {
        this.valueNames.putAll(valueNames);
        return this;
    }

    private static boolean GetBitValue(long val, int index) {
        return (val & 1L << index) != 0L;
    }

    public NumberItemType bit(int bitIndex, String trueNote) {
        if (bitIndex >= this.allBits) {
            throw new IllegalArgumentException("bit" + bitIndex + " > " + this.allBits);
        }
        BitsType instance = new BitsType(bitIndex, 1).put(1, trueNote);
        this.bitMap.put(bitIndex, instance);
        return this;
    }

    public NumberItemType bits(int lowBitIndex, int highBitIndex, Object ... map) {
        BitsType instance = new BitsType(lowBitIndex, highBitIndex + 1 - lowBitIndex);
        for (int i = 0; i < map.length; i += 2) {
            Integer key = (Integer)map[i];
            String note = (String)map[i + 1];
            instance.put(key, note);
        }
        this.bitMap.put(lowBitIndex, instance);
        return this;
    }

    public NumberItemType \u5c0f\u6570\u4f4d\u6570(int len) {
        this.\u5c0f\u6570\u90e8\u5206\u4f4d\u6570 = len;
        this.fenmu = (long)Math.pow(10.0, len);
        return this;
    }

    public NumberItemType \u663e\u793a\u8fdb\u5236(int digits) {
        this.\u663e\u793a\u8fdb\u5236 = digits;
        return this;
    }

    public NumberItemType defaultVal(long defaultVal) {
        this.defaultVal = defaultVal;
        return this;
    }

    @Override
    public Item create() {
        return this._newItem(this.defaultVal);
    }

    @Override
    public Item load(Scanner in) {
        long val = this.defaultVal;
        try {
            val = in.nextLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._newItem(val);
    }

    public NumberItemType decoder(Function<Long, Long> decoder, Function<Long, Long> encoder) {
        this.decoder = this.decoder == NULL ? decoder : decoder.andThen(decoder);
        this.encoder = this.encoder == NULL ? encoder : encoder.andThen(encoder);
        return this;
    }

    @Override
    public Item load(BytesLoader in) {
        long value = 0L;
        if (this.bits() == 0) {
            for (int i = 0; i < this.bytes(); ++i) {
                value <<= 8;
                value |= (long)(in.loadByte() & 0xFF);
            }
        } else {
            value = in.loadBits(this.allBits);
        }
        return this._newItem(this.decoder.apply(value));
    }

    @Override
    protected Class insideValueClass() {
        return Long.class;
    }

    @Override
    protected void safeSetItemValue(Item item, Object newValue) {
        Long longObject = this.objectToLong(newValue);
        item.unsafeSetValue(longObject);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = this.objectToLong(itemValue);
        val = this.encoder.apply(val);
        if (this.bits() == 0) {
            out.skip(this.bytes());
            for (int i = 1; i <= this.bytes(); ++i) {
                out.setBack(i, (int)val & 0xFF);
                val >>= 8;
            }
        } else {
            out.addBits(this.allBits, val);
        }
    }

    protected long objectToLong(Object itemValue) {
        if (itemValue instanceof Number) {
            return ((Number)itemValue).longValue();
        }
        throw new IllegalArgumentException(itemValue == null ? "null" : itemValue.getClass().toString() + ": " + itemValue);
    }

    public double toDouble(Object itemValue) {
        double doubleVal = this.objectToLong(itemValue);
        return doubleVal /= (double)this.fenmu;
    }

    public boolean isDoubleType() {
        return this.fenmu > 1L;
    }

    private static long BitGet(long oldVal, int bitIndex, int bitCount) {
        long getVal = oldVal >> bitIndex & (long)(~(-1 << bitCount));
        return getVal;
    }

    private static long BitSet(long oldVal, int bitIndex, int bitCount, long bitsVal) {
        long setVal = bitsVal << bitIndex;
        long newVal = (long)(~(~(-1 << bitCount) << bitIndex)) & oldVal | setVal;
        return newVal;
    }

    @Override
    public String toString(Object itemValue) {
        long val = this.objectToLong(itemValue);
        if (this.isDoubleType()) {
            String ret = String.valueOf(val / this.fenmu) + '.' + val % this.fenmu;
            return ret;
        }
        StringBuilder ret = new StringBuilder();
        switch (this.\u663e\u793a\u8fdb\u5236) {
            case 2: {
                ret.append("0b").append(Long.toBinaryString(val));
                break;
            }
            case 16: {
                ret.append("0x").append(Long.toHexString(val));
                break;
            }
            default: {
                ret.append(val);
            }
        }
        String valueName = this.valueNames.getOrDefault(val, this.valueElseName);
        if (valueName != null) {
            ret.append("(").append(valueName).append(")");
        }
        if (!this.bitMap.isEmpty()) {
            String bitNotes = this.bitMap.values().stream().filter(e -> e.getBitValue(val) != 0).map(a -> a.getValueNote(val)).collect(Collectors.joining("|", "(", ")"));
            ret.append(bitNotes);
        }
        return ret.toString();
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        if (this.isDoubleType()) {
            double value = this.toDouble(item.getValue());
            statement.setDouble(pos++, value);
        } else {
            statement.setLong(pos++, item.longValue());
        }
        return 1;
    }

    @Override
    public double toDoubleImpl(Item item) {
        double doubleVal = this.objectToLong(item.getValue());
        return doubleVal /= (double)this.fenmu;
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class BitsType {
        final int lowBitIndex;
        final int bitCnt;
        final Map<Integer, String> bitsMap = new TreeMap<Integer, String>();

        BitsType(int lowBitIndex, int bitCnt) {
            this.lowBitIndex = lowBitIndex;
            this.bitCnt = bitCnt;
        }

        BitsType put(int key, String bitNote) {
            this.bitsMap.put(key, bitNote);
            return this;
        }

        int getBitValue(long value) {
            return (int)NumberItemType.BitGet(value, this.lowBitIndex, this.bitCnt);
        }

        String getValueNote(long itemValue) {
            int bitVal = this.getBitValue(itemValue);
            return this.bitsMap.get(bitVal);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("{").append(this.lowBitIndex);
            if (this.bitCnt > 1) {
                buf.append("~").append(this.lowBitIndex + this.bitCnt);
            }
            buf.append(",").append(this.bitsMap).append("}");
            return buf.toString();
        }
    }
}

