/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import cn.gongler.util.protocol.itemtype.ItemTypeStruct;
import cn.gongler.util.protocol.itemtype.IteratorBuilder;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;

public class ListItemType
extends ItemType<ListItemType> {
    private static final long serialVersionUID = 1L;
    protected ItemType subItemType;
    int headSize = 1;
    static final List INIT_VAL = Collections.emptyList();
    boolean wrapperByStruct = false;

    public ItemType subItemType() {
        return this.subItemType;
    }

    public static ListItemType of(String name, ItemType ... subItemTypes) {
        int size = subItemTypes.length;
        if (size > 1) {
            return new ListItemType(name, new ItemTypeStructOfList(name, subItemTypes)).wrapperByStruct();
        }
        if (size == 1) {
            return new ListItemType(name, subItemTypes[0]);
        }
        throw new IllegalArgumentException("subItemTypes.size must >=1");
    }

    public ListItemType wrapperByStruct() {
        this.wrapperByStruct = true;
        return this;
    }

    protected ListItemType(String name, ItemType subItemType) {
        super(name);
        this.subItemType = subItemType;
    }

    public ListItemType headSize(int headSize) {
        this.headSize = headSize;
        return this;
    }

    protected List<Item> _newValue() {
        return new ArrayList<Item>();
    }

    @Override
    public Item create() {
        return this._newItem(this._newValue());
    }

    @Override
    public Item load(Scanner in) {
        int size = in.nextInt();
        List<Item> groups = this._newValue();
        for (int i = 0; i < size; ++i) {
            groups.add(this.subItemType.load(in));
        }
        return this._newItem(groups);
    }

    @Override
    public Item load(BytesLoader in) {
        int len = in.loadInt(this.headSize);
        List<Item> groups = this._newValue();
        for (int i = 0; i < len; ++i) {
            groups.add(this.subItemType.load(in));
        }
        return this._newItem(groups);
    }

    @Override
    public Item load(Iterator<Object> in) {
        int len = ((Number)in.next()).intValue();
        List<Item> groups = this._newValue();
        for (int i = 0; i < len; ++i) {
            Item subItem = this.subItemType.load(in);
            groups.add(subItem);
        }
        return this._newItem(groups);
    }

    public Item LoadOne(Iterator<Object> in) {
        return this.subItemType.load(in);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof List) {
            List groups = (List)itemValue;
            int len = groups.size();
            build.addNum(this.headSize, len);
            for (Item item : groups) {
                item.toBytes(build);
            }
        }
    }

    @Override
    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        List subitems = (List)itemValue;
        build.add((Object)subitems.size());
        subitems.forEach(subitem -> subitem.toFlatObject(build));
    }

    @Override
    protected Class insideValueClass() {
        return List.class;
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue != null) {
            List items = (List)itemValue;
            return items.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
        }
        return "null";
    }

    @Override
    public int dbParamCount() {
        return 1;
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, item.formatFlatObjects());
        return 1;
    }

    @Override
    public List<? extends ItemType> flatItemTypes() {
        return Collections.singletonList(CSTR);
    }

    @Override
    protected List<Item> itemValue(Item item) {
        return (List)item.getValue();
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        Object list = this.itemValue(item);
        Item subItem = (Item)list.get(key);
        return subItem;
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        Item newItem = this.subItemType().create().setValue(subitemValue);
        ((List)item.getValue()).add(newItem);
    }

    private static class ItemTypeStructOfList
    extends ItemTypeStruct {
        public ItemTypeStructOfList(String name, ItemType ... itemTypes) {
            super(name, itemTypes);
        }
    }
}

