/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.BytesItemType;
import cn.gongler.util.protocol.itemtype.DatetimeBcdItemType;
import cn.gongler.util.protocol.itemtype.FlagSignedNumberItemType;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemTypeStruct;
import cn.gongler.util.protocol.itemtype.IteratorBuilder;
import cn.gongler.util.protocol.itemtype.ListItemType;
import cn.gongler.util.protocol.itemtype.NumberItemType;
import cn.gongler.util.protocol.itemtype.StringItemType;
import cn.gongler.util.protocol.itemtype.StringWithLengthItemType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.function.Function;

public abstract class ItemType<T extends ItemType> {
    private static final long serialVersionUID = 1L;
    public static final ItemType CSTR = new StringItemType("CSTR").description("'\u0000'\u4ee5\u7ed3\u5c3e\u7684\u5b57\u7b26\u4e32\u9879");
    private final String name;
    private String description = "";

    public static NumberItemType \u5305\u7c7b\u578b(int cmdType, String name) {
        NumberItemType type = ItemType.HEX(1, name).defaultVal(cmdType);
        return type;
    }

    public static NumberItemType NUM(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name);
        return type;
    }

    public static NumberItemType DEC(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name).\u663e\u793a\u8fdb\u5236(10);
        return type;
    }

    public static NumberItemType HEX(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name).\u663e\u793a\u8fdb\u5236(16);
        return type;
    }

    public static NumberItemType BIN(int byteCount, String name) {
        NumberItemType type = new NumberItemType(byteCount, name).\u663e\u793a\u8fdb\u5236(2);
        return type;
    }

    public static NumberItemType BITS(int bitCnt, String name) {
        NumberItemType type = new NumberItemType(0, bitCnt, name);
        return type;
    }

    public static StringWithLengthItemType STR(int byteCount, String name) {
        StringWithLengthItemType type = byteCount > 0 ? StringWithLengthItemType.withFixLength(byteCount, name) : StringWithLengthItemType.withFixLength(byteCount, name);
        return type;
    }

    public static FlagSignedNumberItemType SNUM(int byteCnt, String name) {
        FlagSignedNumberItemType type = new FlagSignedNumberItemType(byteCnt, name);
        return type;
    }

    public static ItemType BYTES(int bytes, String name) {
        return new BytesItemType(bytes, name);
    }

    public static ItemType REMAIN_BYTES(String name) {
        return new BytesItemType(0, name);
    }

    public static ItemType BYTES_ASC(int bytes, String name) {
        return StringWithLengthItemType.withFixLength(bytes, name);
    }

    public static ItemType LIST(String name, ItemType ... ItemTypeGroup) {
        return ListItemType.of(name, ItemTypeGroup);
    }

    public static ItemType LIST_H4(String name, ItemType ... ItemTypeGroup) {
        return ListItemType.of(name, ItemTypeGroup).headSize(4);
    }

    public static ItemType STRUCT(String name, ItemType ... ItemTypeGroup) {
        return new ItemTypeStruct(name, ItemTypeGroup);
    }

    public static NumberItemType BCD(int bytes, String name) {
        return NumberItemType.BCD(bytes, name);
    }

    public static ItemType BCD_DATETIME(String name) {
        return DatetimeBcdItemType.YYMMDDHHMMSS(name);
    }

    public static ItemType BCD_DATE(String name) {
        return DatetimeBcdItemType.YYMMDD(name);
    }

    protected ItemType(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public T description(String describe) {
        this.description = describe;
        return (T)this;
    }

    public String description() {
        return this.description;
    }

    public boolean match(Item item) {
        return item != null && this.equals(item.itemType());
    }

    public abstract Item load(BytesLoader var1);

    public abstract Item load(Scanner var1);

    public Item load(Iterator<Object> in) {
        return this.create().setValue(in.next());
    }

    public Item load(Object first, Object ... objects) {
        return this.load(new IteratorBuilder<Object>().add(first).add((Object[])objects).iterator());
    }

    public abstract void toBytes(Object var1, BytesBuilder var2);

    public final void toBytes(Item item, BytesBuilder build) {
        this.toBytes(item.getValue(), build);
    }

    public String toString(Item item) {
        if (this.match(item)) {
            return this.toString(item.getValue());
        }
        return "null";
    }

    public String toString(Object itemValue) {
        if (itemValue != null) {
            return String.valueOf(itemValue);
        }
        return "null";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "_" + this.name;
    }

    public abstract Item create();

    private boolean matchInsideValueType(Object value) {
        return value != null && this.insideValueClass().isInstance(value);
    }

    protected abstract Class insideValueClass();

    public int dbParamCount() {
        return 1;
    }

    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setObject(pos, item.getValue());
        return 1;
    }

    public final String formatFlatObjects(Item item) {
        IteratorBuilder<Object> build = new IteratorBuilder<Object>();
        item.toFlatObject(build);
        return build.toString("|");
    }

    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        build.add(itemValue);
    }

    protected void safeSetItemValue(Item item, Object value) {
        if (!this.matchInsideValueType(value)) {
            throw new IllegalArgumentException("\u8d4b\u503c\u7c7b\u578b\u9519\u8bef\uff1a" + item.itemType().toString() + "<-" + value);
        }
        item.unsafeSetValue(value);
    }

    static <T> T apply(T obj, Function<T, T> func) {
        return func.apply(obj);
    }

    protected final Item _newItem(Object newItemValue) {
        Item instance = new Item(this, newItemValue);
        return instance;
    }

    public List<? extends ItemType> flatItemTypes() {
        return Collections.singletonList(this);
    }

    public double toDoubleImpl(Item item) {
        throw new UnsupportedOperationException();
    }

    protected Object itemValue(Item item) {
        return item.getValue();
    }

    protected final void setSubitemImpl(Item item, int key, Object newValue) {
        this.getSubitemImpl(item, key).setValue(newValue);
    }

    protected abstract Item getSubitemImpl(Item var1, int var2);

    protected abstract void addSubitemImpl(Item var1, Object var2);
}

