/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.NumberItemType;

public class FlagSignedNumberItemType
extends NumberItemType {
    private static final long serialVersionUID = 1L;
    final long flagMask;
    final long valMask;

    public FlagSignedNumberItemType(int bytes, String name) {
        this(bytes, 0, name);
    }

    public FlagSignedNumberItemType(int bytes, int bits, String name) {
        super(bytes, bits, name);
        if (this.bits() == 0) {
            this.flagMask = 1 << this.bytes() * 8 - 1;
            long valM = 0L;
            for (int i = 0; i < bytes; ++i) {
                valM <<= 8;
                valM |= 0xFFL;
            }
            this.valMask = valM ^= this.flagMask;
        } else {
            this.flagMask = 1 << this.allBits() - 1;
            long valM = 0L;
            for (int i = 0; i < this.allBits(); ++i) {
                valM <<= 1;
                valM |= 1L;
            }
            this.valMask = valM ^= this.flagMask;
        }
    }

    private long decodeValue(long val) {
        boolean minus = (val & this.flagMask) != 0L;
        long absVal = val & this.valMask;
        return minus ? -absVal : absVal;
    }

    private long encodeValue(long val) {
        if (val > 0L) {
            return val;
        }
        return -val & this.valMask | this.flagMask;
    }

    @Override
    public Item load(BytesLoader in) {
        Item item = super.load(in);
        item.setValue(this.decodeValue(item.longValue()));
        return item;
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = this.encodeValue(this.objectToLong(itemValue));
        super.toBytes(val, out);
    }
}

