/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.net.client;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.ITask;
import cn.gongler.util.QueueConsumer;
import cn.gongler.util.function.ExceptionBiConsumer;
import cn.gongler.util.function.ExceptionFunction;
import cn.gongler.util.net.client.IClientSender;
import cn.gongler.util.net.client.IReceiveHandler;
import cn.gongler.util.net.client.ITcpClientContext;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.LocalDateTime;
import java.util.Timer;
import java.util.function.Supplier;

public class TcpClient<Pack> {
    private static final long serialVersionUID = 1L;
    Socket socket = null;
    Timer timer;
    InetSocketAddress svrAddr;
    QueueConsumer sendConsumer;
    QueueConsumer recvConsumer;
    DataInputStream in = null;
    OutputStream out = null;
    private LocalDateTime connectTime;
    private ReceiveTask lastRecvTask = null;
    private ExceptionFunction<Pack, byte[]> packToBytes;
    private ExceptionBiConsumer<ITcpClientContext, IClientSender<Pack>> heartHandler = (cxt, s) -> {};
    ITcpClientContext cxt;

    public TcpClient(String host, int port, Supplier<IReceiveHandler<Pack>> recvFactory, ExceptionFunction<Pack, byte[]> packToBytes, ExceptionFunction<ITcpClientContext, Pack> connPackFactory, ExceptionFunction<ITcpClientContext, Pack> heartPackFactory) {
        this.svrAddr = new InetSocketAddress(host, port);
        this.sendConsumer = QueueConsumer.of("sender");
        this.recvConsumer = QueueConsumer.of("receiver");
        this.packToBytes = packToBytes;
        this.timer = new Timer();
        this.timer.schedule(GonglerUtil.TimerTask(() -> {
            if (this.socket == null) {
                final Socket socket = new Socket();
                socket.connect(this.svrAddr);
                this.socket = socket;
                this.in = new DataInputStream(socket.getInputStream());
                this.out = socket.getOutputStream();
                this.connectTime = LocalDateTime.now();
                this.cxt = new ITcpClientContext(){

                    @Override
                    public LocalDateTime connectedTime() {
                        return TcpClient.this.connectTime;
                    }

                    @Override
                    public InetSocketAddress svrAddr() {
                        return TcpClient.this.svrAddr;
                    }

                    @Override
                    public InetSocketAddress clientAddr() {
                        return (InetSocketAddress)socket.getLocalSocketAddress();
                    }
                };
                Object connPack = connPackFactory.apply(this.cxt);
                if (connPack != null) {
                    this.send(connPack);
                }
                this.lastRecvTask = new ReceiveTask(() -> this.lambda$null$1((Supplier)recvFactory));
                this.recvConsumer.accept(this.lastRecvTask);
            } else {
                this.send(heartPackFactory.apply(this.cxt));
                this.heartHandler.accept(this.cxt, this::send);
            }
        }), 1000L, 10000L);
    }

    public void heartEvent(ExceptionBiConsumer<ITcpClientContext, IClientSender<Pack>> heartHandler) {
        this.heartHandler = heartHandler;
    }

    public void send(Pack pack) {
        this.sendConsumer.accept(() -> {
            try {
                byte[] bytes = this.packToBytes.apply(pack);
                this.out.write(bytes);
                this.out.flush();
            }
            catch (IOException e) {
                if (this.lastRecvTask != null) {
                    this.lastRecvTask.stop();
                }
                GonglerUtil.Close(this.out);
                GonglerUtil.Close(this.in);
                GonglerUtil.Close(this.socket);
                this.socket = null;
            }
        });
    }

    private /* synthetic */ void lambda$null$1(Supplier recvFactory) throws Exception {
        ((IReceiveHandler)recvFactory.get()).accept(this.cxt, this.in, this::send);
    }

    private class ReceiveTask
    implements ITask {
        volatile boolean cancel = false;
        private final ITask task;

        ReceiveTask(ITask task) {
            this.task = task;
        }

        public void stop() {
            this.cancel = true;
        }

        @Override
        public void run() throws Exception {
            try {
                this.task.run();
            }
            catch (IOException e) {
                GonglerUtil.Close(TcpClient.this.socket);
                TcpClient.this.socket = null;
                throw e;
            }
        }
    }
}

