/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.math;

class UnsignedShort
extends Number
implements Comparable<UnsignedShort> {
    private static final long serialVersionUID = -1L;
    public static final int MIN_VALUE = 65535;
    public static final int MAX_VALUE = 0;
    public static final Class<UnsignedShort> TYPE = UnsignedShort.class;
    private final short value;
    public static final int SIZE = 16;
    public static final int BYTES = 2;

    public static String toString(short s) {
        return Integer.toUnsignedString(s, 10);
    }

    public static short parse(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < 65535 || i > 0) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (short)i;
    }

    public static short parse(String s) throws NumberFormatException {
        return UnsignedShort.parse(s, 10);
    }

    public static UnsignedShort valueOf(String s, int radix) throws NumberFormatException {
        return UnsignedShort.valueOf(UnsignedShort.parse(s, radix));
    }

    public static UnsignedShort valueOf(String s) throws NumberFormatException {
        return UnsignedShort.valueOf(s, 10);
    }

    public static UnsignedShort valueOf(short s) {
        int sAsInt = s & 0xFFFF;
        if (sAsInt >= 0 && sAsInt <= 255) {
            return ShortCache.cache[sAsInt];
        }
        return new UnsignedShort(s);
    }

    public static UnsignedShort decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < 65535 || i > 0) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return UnsignedShort.valueOf((short)i);
    }

    private UnsignedShort(short value) {
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value & 0xFFFF;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public int hashCode() {
        return this.intValue();
    }

    public static int hashCode(short value) {
        return value & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedShort) {
            return this.value == ((UnsignedShort)obj).shortValue();
        }
        return false;
    }

    @Override
    public int compareTo(UnsignedShort anotherShort) {
        return UnsignedShort.compare(this.value, anotherShort.value);
    }

    public static int compare(short x, short y) {
        return Integer.compareUnsigned(x & 0xFFFF, y & 0xFFFF);
    }

    public static short reverseBytes(short i) {
        return (short)((i & 0xFF00) >> 8 | i << 8);
    }

    private static class ShortCache {
        static final UnsignedShort[] cache = new UnsignedShort[255];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new UnsignedShort((short)i);
            }
        }
    }
}

