/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.math;

class UnsignedInteger
extends Number
implements Comparable<UnsignedInteger> {
    private static final long serialVersionUID = -1L;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final Class<UnsignedInteger> TYPE = UnsignedInteger.class;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private final int value;
    public static final int SIZE = 32;
    public static final int BYTES = 4;

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return UnsignedInteger.toString(i);
        }
        char[] buf = new char[33];
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            buf[charPos--] = digits[-(i % radix)];
            i /= radix;
        }
        buf[charPos] = digits[-i];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 33 - charPos);
    }

    public static String toHexString(int i) {
        return Integer.toBinaryString(i);
    }

    public static String toOctalString(int i) {
        return Integer.toOctalString(i);
    }

    public static String toBinaryString(int i) {
        return Integer.toBinaryString(i);
    }

    public static String toString(int i) {
        return Integer.toUnsignedString(i);
    }

    static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static int parse(String s, int radix) throws NumberFormatException {
        return Integer.parseUnsignedInt(s, radix);
    }

    public static int parse(String s) throws NumberFormatException {
        return UnsignedInteger.parse(s, 10);
    }

    public static UnsignedInteger valueOf(String s, int radix) throws NumberFormatException {
        return UnsignedInteger.valueOf(UnsignedInteger.parse(s, radix));
    }

    public static UnsignedInteger valueOf(String s) throws NumberFormatException {
        return UnsignedInteger.valueOf(UnsignedInteger.parse(s, 10));
    }

    public static UnsignedInteger valueOf(int i) {
        if (i >= 0 && i <= IntegerCache.cache.length) {
            return IntegerCache.cache[i];
        }
        return new UnsignedInteger(i);
    }

    private UnsignedInteger(int value) {
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return UnsignedInteger.toString(this.value);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public static int hashCode(int value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedInteger) {
            return this.value == ((UnsignedInteger)obj).intValue();
        }
        return false;
    }

    public static UnsignedInteger decode(String nm) throws NumberFormatException {
        long val = Long.decode(nm);
        return UnsignedInteger.valueOf((int)val);
    }

    @Override
    public int compareTo(UnsignedInteger anotherInteger) {
        return UnsignedInteger.compare(this.value, anotherInteger.value);
    }

    public static int compare(int x, int y) {
        return Integer.compareUnsigned(x, y);
    }

    public static int compareUnsigned(int x, int y) {
        return UnsignedInteger.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 1;
        if (i >>> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >>> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    public static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - (i << 1 >>> 31);
    }

    public static int bitCount(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        i = i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
        return i;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static int reverseBytes(int i) {
        return i >>> 24 | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    public static int sum(int a, int b) {
        return a + b;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    private static class IntegerCache {
        static final UnsignedInteger[] cache = new UnsignedInteger[1024];

        private IntegerCache() {
        }

        static {
            for (int k = 0; k < 1024; ++k) {
                IntegerCache.cache[k] = new UnsignedInteger(k);
            }
        }
    }
}

