/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.io;

import cn.gongler.util.GonglerUtil;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Timer;

public class NoFlushOutputStream
extends FilterOutputStream {
    private static final long serialVersionUID = 1L;
    private static final Timer timer = new Timer(true);

    public static void BufferedSystemOut() {
        System.setOut(NoFlushOutputStream.BufferedPrintStream(System.out));
    }

    public static PrintStream BufferedPrintStream(PrintStream out) {
        return new PrintStream(new NoFlushOutputStream(out, 5));
    }

    public static PrintStream BufferedPrintStream(PrintStream out, int delaySecondsMax) {
        return new PrintStream(new NoFlushOutputStream(out, delaySecondsMax));
    }

    private NoFlushOutputStream(OutputStream out, int delaySecondsMax) {
        super(new MyBufferedOutputStream(out));
        Runtime.getRuntime().addShutdownHook(new Thread(this::forceFlush));
        timer.schedule(GonglerUtil.TimerTask(this::forceFlush), 1000 * delaySecondsMax, (long)(1000 * delaySecondsMax));
    }

    private MyBufferedOutputStream out() {
        return (MyBufferedOutputStream)this.out;
    }

    private void forceFlush() {
        try {
            if (this.out().bufReadableCount() > 0) {
                this.out().flush();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.forceFlush();
        this.out.close();
    }

    private static class MyBufferedOutputStream
    extends BufferedOutputStream {
        public MyBufferedOutputStream(OutputStream out) {
            super(out);
        }

        public int bufReadableCount() {
            return this.count;
        }
    }
}

