/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface ExceptionFunction<T, R> {
    public R apply(T var1) throws Exception;

    default public R applyWithCatchAny(T t) {
        return this.applyWithCatchAny(t, null);
    }

    default public R applyWithCatchAny(T t, R defaultVal) {
        try {
            return this.apply(t);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return defaultVal;
        }
    }

    default public R applyWithThrowAny(T t) {
        return (R)GonglerUtil.CallWithThrowAny(() -> this.apply(t));
    }

    default public <V> ExceptionFunction<V, R> compose(ExceptionFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> ExceptionFunction<T, V> andThen(ExceptionFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    public static <T> ExceptionFunction<T, T> identity() {
        return t -> t;
    }

    default public Function<T, R> toFunction() {
        return t -> GonglerUtil.CallWithThrowAny(() -> this.apply(t));
    }
}

