/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;
import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface ExceptionConsumer<T> {
    public void accept(T var1) throws Exception;

    default public ExceptionConsumer<T> acceptThen(T t) throws Exception {
        this.accept(t);
        return this;
    }

    default public void acceptWithCatchAny(T t) {
        GonglerUtil.ExecuteWithCatchAny(() -> this.accept(t));
    }

    default public void acceptWithThrowAny(T t) {
        GonglerUtil.ExecuteWithThrowAny(() -> this.accept(t));
    }

    default public ExceptionConsumer<T> andThen(ExceptionConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return l -> {
            this.accept(l);
            after.accept(l);
        };
    }

    default public Consumer<T> toBiConsumer() {
        return t -> GonglerUtil.ExecuteWithThrowAny(() -> this.accept(t));
    }
}

