/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.db;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.db.DataSourceAdapter;
import cn.gongler.util.db.IDbTask;
import cn.gongler.util.function.ExceptionConsumer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

@FunctionalInterface
public interface ConnectionFactory
extends ExceptionConsumer<IDbTask> {
    public Connection getConnection() throws SQLException;

    public static ConnectionFactory of(String url, String user, String password) {
        return () -> DriverManager.getConnection(url, user, password);
    }

    public static ConnectionFactory of(String url, Properties info) {
        return () -> DriverManager.getConnection(url, info);
    }

    public static ConnectionFactory of(DataSource ds) {
        return ds::getConnection;
    }

    default public DataSource toDataSource() {
        return DataSourceAdapter.of(this);
    }

    @Override
    default public void accept(IDbTask task) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            task.accessDb(conn);
            GonglerUtil.Commit(conn);
        }
        catch (Exception e) {
            GonglerUtil.Rollback(conn);
            throw GonglerUtil.toRuntimeException(e);
        }
        finally {
            GonglerUtil.Close(conn);
        }
    }
}

