/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.collection;

import java.time.Duration;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class EasyDelayQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    private final long defaultDelayMillis;
    final DelayQueue<Entry<E>> queue;

    public EasyDelayQueue(Duration defaultDelay) {
        this.defaultDelayMillis = defaultDelay.toMillis();
        this.queue = new DelayQueue();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<Entry<E>> itr = this.queue.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public E next() {
                Entry entry = (Entry)itr.next();
                return entry == null ? null : entry.getValue();
            }
        };
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean offer(E e) {
        return this.queue.offer(new Entry<E>(e, this.defaultDelayMillis));
    }

    public boolean offer(E e, Duration delay) {
        long millis = delay.toMillis();
        return this.queue.offer(new Entry<E>(e, millis));
    }

    @Override
    public E poll() {
        Entry entry = (Entry)this.queue.poll();
        return (E)(entry == null ? null : entry.getValue());
    }

    @Override
    public E peek() {
        Entry entry = (Entry)this.queue.peek();
        return (E)(entry == null ? null : entry.getValue());
    }

    @Override
    public void put(E e) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(new Entry<E>(e, this.defaultDelayMillis), timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        return (E)((Entry)this.queue.take()).getValue();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Entry entry = (Entry)this.queue.poll(timeout, unit);
        return (E)(entry == null ? null : entry.getValue());
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        ArrayList list = new ArrayList(maxElements);
        int count = this.queue.drainTo(list, maxElements);
        list.forEach(e -> c.add(((Entry)e).getValue()));
        return count;
    }

    class Entry<T>
    implements Delayed {
        final long destTime;
        final T e;

        Entry(T e, long millis) {
            this.destTime = System.currentTimeMillis() + millis;
            this.e = e;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.destTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compareUnsigned(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }

        private T getValue() {
            return this.e;
        }
    }
}

