/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.ToBytes;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class Str
implements ToBytes {
    private final int byteCnt;
    private final CharSequence msg;
    private final Charset charset;

    public static Str of(int byteCnt, CharSequence msg) {
        return Str.utf8(byteCnt, msg);
    }

    public static Str of(int byteCnt, CharSequence msg, Charset charset) {
        return new Str(byteCnt, msg, charset);
    }

    public static Str gbk(int byteCnt, CharSequence msg) {
        return Str.of(byteCnt, msg, Charset.forName("GBK"));
    }

    public static Str utf8(int byteCnt, CharSequence msg) {
        return Str.of(byteCnt, msg, StandardCharsets.UTF_8);
    }

    private Str(int byteCnt, CharSequence msg, Charset charset) {
        this.byteCnt = byteCnt;
        this.msg = msg;
        this.charset = charset;
    }

    @Override
    public byte[] toBytes() {
        byte[] body = this.msg.toString().getBytes(this.charset);
        if (this.byteCnt > 0) {
            return Arrays.copyOf(body, this.byteCnt);
        }
        if (this.byteCnt < 0) {
            return BytesBuilder.of().addNum(-this.byteCnt, body.length).addBytes(body).toBytes();
        }
        return BytesBuilder.of().addBytes(body).addByte(0).toBytes();
    }
}

