/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.BitsBuilder;
import cn.gongler.util.bytes.BytesBuildable;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.bytes.IBytesRange;
import cn.gongler.util.bytes.SimpleByteArrayRange;
import cn.gongler.util.bytes.Str;
import cn.gongler.util.bytes.ToBytes;
import cn.gongler.util.bytes.function.IntByteConsumer;
import cn.gongler.util.bytes.function.IntByteOperator;
import cn.gongler.util.bytes.function.LongByteOperator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class BytesBuilder
implements ToBytes {
    private static final long serialVersionUID = 8467353696428321139L;
    private boolean defaultIsBigEndian = true;
    protected final int initCapacity;
    protected byte[] buf;
    protected int pos = 0;
    private final BitsBuilder bitBuilder = new BitsBuilder(this::addByte);
    protected int mark = 0;
    private int limited = Integer.MAX_VALUE;
    private static final BigInteger INT100 = new BigInteger("100");
    private static final BigInteger INT_FF = new BigInteger("255");

    public static BytesBuilder of() {
        return BytesBuilder.bigEndian();
    }

    public static BytesBuilder littleEndian() {
        return new BytesBuilder().byteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    public static BytesBuilder bigEndian() {
        return new BytesBuilder().byteOrder(ByteOrder.BIG_ENDIAN);
    }

    protected BytesBuilder() {
        this(512);
    }

    protected BytesBuilder(int initCapacity) {
        this.initCapacity = initCapacity;
        this.buf = new byte[initCapacity];
    }

    public BytesBuilder initCapacity(int initCapacity) {
        if (initCapacity > this.buf().length) {
            this.prepareNextWriteBytes(initCapacity - this.pos);
        }
        return this;
    }

    protected byte[] buf() {
        return this.buf;
    }

    protected void prepareNextWriteBytes(int newBytes) {
        GonglerUtil.require(this.pos + newBytes <= this.limited);
        if (this.pos + newBytes > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, 64 + Math.max(this.buf.length * 2, this.pos + newBytes));
        }
    }

    private BytesBuilder byteOrder(boolean isBigEndian) {
        this.defaultIsBigEndian = isBigEndian;
        return this;
    }

    public BytesBuilder byteOrder(ByteOrder defaultByteOrder) {
        this.defaultIsBigEndian = ByteOrder.BIG_ENDIAN.equals(defaultByteOrder);
        return this;
    }

    public ByteOrder byteOrder() {
        return this.defaultIsBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public BytesBuilder skip(int byteCnt) {
        this.requireBitsFinished();
        this.prepareNextWriteBytes(byteCnt);
        this.movePos(byteCnt);
        return this;
    }

    protected void movePos(int byteCnt) {
        this.pos += byteCnt;
    }

    public BytesBuilder mark() {
        this.mark = this.pos;
        return this;
    }

    public BytesBuilder moveToMark() {
        this.pos = this.mark;
        return this;
    }

    protected int pos() {
        return this.pos;
    }

    protected BytesBuilder pos(int newPos) {
        this.pos = newPos;
        return this;
    }

    public BytesBuilder setBack(int backIndex, int byteVal) {
        if (backIndex <= 0) {
            throw new IllegalArgumentException("\u4e3a\u4e86\u9632\u6b62\u5fd8\u8bb0\u79fb\u52a8\u6e38\u6807\uff0c\u5f3a\u5236\u53ea\u80fd\u4fee\u6539\u4e4b\u524d\u6570\u636e");
        }
        this.buf()[this.pos - backIndex] = (byte)byteVal;
        return this;
    }

    public BytesBuilder limited(int limited) {
        this.limited = limited;
        return this;
    }

    public int limited() {
        return this.limited;
    }

    public BytesBuilder duplicate() {
        final Supplier<byte[]> bufSupplier = () -> this.buf();
        BytesBuilder view = new BytesBuilder(){

            @Override
            public byte[] buf() {
                this.buf = (byte[])bufSupplier.get();
                return this.buf;
            }
        };
        view.buf = this.buf();
        view.pos = view.mark = this.pos;
        view.defaultIsBigEndian = this.defaultIsBigEndian;
        view.limited = this.limited;
        return view;
    }

    public BytesBuilder duplicate(int newPos) {
        return this.duplicate().pos(newPos);
    }

    public BytesBuilder slice(int byteCnt) {
        BytesBuilder view = this.duplicate();
        view.limited = byteCnt;
        this.skip(byteCnt);
        return view;
    }

    protected BytesBuilder fillValueAtPos(int byteValue) {
        this.buf()[this.pos] = (byte)byteValue;
        return this;
    }

    public BytesBuilder setByte(int globalIndex, int byteVal) {
        this.buf()[globalIndex] = (byte)byteVal;
        return this;
    }

    public BytesBuilder setBytes(int globalIndex, byte[] block) {
        for (int i = 0; i < block.length; ++i) {
            this.buf()[globalIndex + i] = block[i];
        }
        return this;
    }

    public BytesBuilder setBytes(int globalIndex, ToBytes item) {
        byte[] block = item.toBytes();
        for (int i = 0; i < block.length; ++i) {
            this.buf()[globalIndex + i] = block[i];
        }
        return this;
    }

    public BytesBuilder setNum(int globalIndex, int byteCnt, long val) {
        this.duplicate().pos(globalIndex).addNum(byteCnt, val);
        return this;
    }

    public BytesBuilder setString(int globalIndex, int byteCnt, CharSequence msg, Charset charset) {
        this.duplicate().pos(globalIndex).addString(byteCnt, msg, charset);
        return this;
    }

    public BytesBuilder trace(Consumer<CharSequence> consumer) {
        return this.trace(2, 4, consumer);
    }

    public BytesBuilder trace(int postfix, Consumer<CharSequence> consumer) {
        return this.trace(2, postfix, consumer);
    }

    public BytesBuilder trace(int prefix, int postfix, Consumer<CharSequence> consumer) {
        String pre = HexUtil.BytesToHex(this.buf, Math.max(0, this.pos - prefix), this.pos);
        String post = HexUtil.BytesToHex(this.buf, this.pos, Math.min(this.buf.length, this.pos + postfix));
        String msg = pre + "(" + this.pos + ">)" + post;
        consumer.accept(msg);
        return this;
    }

    protected BytesBuilder _addByte(int byteVal) {
        this.fillValueAtPos(byteVal);
        this.movePos(1);
        return this;
    }

    protected BytesBuilder _addBytes(byte[] buf, int from, int size) {
        this.requireBitsFinished();
        if (size > 0) {
            this.prepareNextWriteBytes(size);
            System.arraycopy(buf, from, this.buf(), this.pos, Math.min(buf.length - from, size));
            this.movePos(size);
        }
        return this;
    }

    public BytesBuilder addByte(int byteVal) {
        this.requireBitsFinished();
        this.prepareNextWriteBytes(1);
        return this._addByte(byteVal);
    }

    public BytesBuilder addByteRepeat(int byteVal, int repeatTimes) {
        for (int i = 0; i < repeatTimes; ++i) {
            this.addByte(byteVal);
        }
        return this;
    }

    public BytesBuilder addBcd(int byteCnt, long val) {
        this.skip(byteCnt);
        for (int i = 0; i < byteCnt; ++i) {
            int byteVal = (int)(val % 100L);
            int high = byteVal / 10;
            int low = byteVal % 10;
            this.setBack(1 + i, high << 4 | low);
            val /= 100L;
        }
        return this;
    }

    public BytesBuilder addBcd(int byteCnt, BigInteger val) {
        this.skip(byteCnt);
        for (int i = 0; i < byteCnt; ++i) {
            int byteVal = val.mod(INT100).intValue();
            int high = byteVal / 10;
            int low = byteVal % 10;
            this.setBack(1 + i, high << 4 | low);
            val = val.divide(INT100);
        }
        return this;
    }

    public BytesBuilder addBcd(int byteCnt, String bcd) {
        return this.addBcd(byteCnt, new BigInteger(bcd));
    }

    public BytesBuilder addShort(int b) {
        return this.addNum(2, b);
    }

    public BytesBuilder addInt(int b) {
        return this.addNum(4, b);
    }

    public BytesBuilder addLong(long b) {
        return this.addNum(8, b);
    }

    public BytesBuilder addNum(int byteCnt, long value) {
        return this.defaultIsBigEndian ? this.addNumBigEndian(byteCnt, value) : this.addNumLittleEndian(byteCnt, value);
    }

    public BytesBuilder addNumLittleEndian(int byteCnt, long value) {
        for (int i = 0; i < byteCnt; ++i) {
            this.addByte((int)(value >> 8 * i) & 0xFF);
        }
        return this;
    }

    public BytesBuilder addNumBigEndian(int byteCnt, long value) {
        for (int i = byteCnt - 1; i >= 0; --i) {
            this.addByte((int)(value >> 8 * i) & 0xFF);
        }
        return this;
    }

    public BytesBuilder addNum(int byteCnt, long value, ByteOrder byteOrder) {
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            this.addNumBigEndian(byteCnt, value);
        } else {
            this.addNumLittleEndian(byteCnt, value);
        }
        return this;
    }

    public BytesBuilder addNum(int byteCnt, String decode) {
        long val = GonglerUtil.DecodeLong(decode);
        return this.addNum(byteCnt, val);
    }

    public BytesBuilder addNum(int byteCnt, BigInteger value) {
        return this.defaultIsBigEndian ? this.addNumBigEndian(byteCnt, value) : this.addNumLittleEndian(byteCnt, value);
    }

    public BytesBuilder addNumLittleEndian(int byteCnt, BigInteger value) {
        for (int i = 0; i < byteCnt; ++i) {
            this.addByte(value.shiftRight(8 * i).mod(INT_FF).intValue());
        }
        return this;
    }

    public BytesBuilder addNumBigEndian(int byteCnt, BigInteger value) {
        for (int i = byteCnt - 1; i >= 0; --i) {
            this.addByte(value.shiftRight(8 * i).mod(INT_FF).intValue());
        }
        return this;
    }

    public BytesBuilder addNum(int byteCnt, BigInteger value, ByteOrder byteOrder) {
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            this.addNumBigEndian(byteCnt, value);
        } else {
            this.addNumLittleEndian(byteCnt, value);
        }
        return this;
    }

    public BytesBuilder addNumPreviousCount(int byteCnt) {
        this.requireBitsFinished();
        this.addNum(byteCnt, this.pos);
        return this;
    }

    public BytesBuilder addHex(int byteCnt, CharSequence hexNum) {
        GonglerUtil.requireLessThenOrEqual(hexNum.length(), byteCnt * 2);
        hexNum = GonglerUtil.Repeat(byteCnt * 2 - hexNum.length(), "0") + hexNum;
        return this.addBytes(hexNum);
    }

    public BytesBuilder addHex(CharSequence hex) {
        return this.addBytes(hex);
    }

    public BytesBuilder addHex(Iterable<CharSequence> hexList) {
        this.requireBitsFinished();
        hexList.forEach(this::addBytes);
        return this;
    }

    public BytesBuilder addHex(int byteCntPerItem, Iterable<CharSequence> hexList) {
        this.requireBitsFinished();
        hexList.forEach((? super T a) -> this.addBytes(byteCntPerItem, (CharSequence)a));
        return this;
    }

    public BytesBuilder addHex(Stream<CharSequence> stream) {
        this.requireBitsFinished();
        stream.forEach(this::addBytes);
        return this;
    }

    public BytesBuilder addHex(CharSequence ... hexArray) {
        this.requireBitsFinished();
        Arrays.stream(hexArray).forEach(this::addBytes);
        return this;
    }

    public <T> BytesBuilder addHex(Iterable<T> list, Function<T, CharSequence> mapper) {
        list.forEach((? super T a) -> this.addBytes((CharSequence)mapper.apply(a)));
        return this;
    }

    public BytesBuilder addString(int byteCnt, CharSequence msg) {
        return this.addUtf8(byteCnt, msg);
    }

    public BytesBuilder addString(int byteCnt, CharSequence msg, Charset charset) {
        return this.addBytes(Str.of(byteCnt, msg, charset).toBytes());
    }

    public BytesBuilder addUtf8(int byteCnt, CharSequence msg) {
        this.addString(byteCnt, msg, StandardCharsets.UTF_8);
        return this;
    }

    public BytesBuilder addGbk(int byteCnt, CharSequence msg) {
        this.addString(byteCnt, msg, Charset.forName("GBK"));
        return this;
    }

    public BytesBuilder addByteStream(InputStream in) {
        try (BufferedInputStream bin = new BufferedInputStream(in);){
            int cnt;
            byte[] inBuf = new byte[1024];
            while ((cnt = ((InputStream)bin).read(inBuf)) >= 0) {
                this.addBytes(inBuf, 0, cnt);
            }
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
        return this;
    }

    public BytesBuilder addByteStream(IntStream stream) {
        stream.forEach(this::addByte);
        return this;
    }

    public BytesBuilder addByteStream(Stream<Byte> stream) {
        stream.mapToInt(Byte::intValue).forEach(this::addByte);
        return this;
    }

    public BytesBuilder addBytes(byte[] buf, int from, int size) {
        GonglerUtil.requireLessThenOrEqual(from + size, buf.length);
        return this._addBytes(buf, from, size);
    }

    public BytesBuilder addBytes(byte[] bytes) {
        return this._addBytes(bytes, 0, bytes.length);
    }

    public BytesBuilder addBytes(int byteCnt, byte[] bytes) {
        return this._addBytes(bytes, 0, byteCnt);
    }

    public BytesBuilder addBytes(CharSequence hex) {
        return this.addBytes(HexUtil.HexToBytes(hex));
    }

    public BytesBuilder addBytes(int byteCnt, CharSequence hex) {
        return this.addBytes(byteCnt, HexUtil.HexToBytes(hex));
    }

    public BytesBuilder addBytes(BytesBuilder another) {
        another.requireBitsFinished();
        return this.addBytes(another.buf(), 0, another.pos);
    }

    public BytesBuilder addBytes(IBytesRange bytesRange) {
        return this.addBytes(bytesRange.buf(), bytesRange.from(), bytesRange.size());
    }

    public BytesBuilder addBytesRefPrevious(Function<IBytesRange, byte[]> mapper) {
        this.requireBitsFinished();
        byte[] bytes = mapper.apply(IBytesRange.of(() -> this.buf(), 0, this.pos));
        this.addBytes(bytes);
        return this;
    }

    public BytesBuilder addBytes(Byte[] bytes) {
        return this.addBytes(bytes, 0, bytes.length);
    }

    public BytesBuilder addBytes(Byte[] bytes, int from, int size) {
        for (int i = 0; i < size; ++i) {
            this.addByte(bytes[from + i].byteValue());
        }
        return this;
    }

    public BytesBuilder addBytes(BytesBuildable item) {
        this.requireBitsFinished();
        item.toBytes(this);
        return this;
    }

    public BytesBuilder addBytes(Iterable<BytesBuildable> items) {
        this.requireBitsFinished();
        items.forEach((? super T a) -> a.toBytes(this));
        return this;
    }

    public BytesBuilder addBytes(ToBytes item) {
        this.requireBitsFinished();
        return this.addBytes(item.toBytes());
    }

    public BytesBuilder addBytes(List<ToBytes> items) {
        items.forEach((? super T a) -> this.addBytes(a.toBytes()));
        return this;
    }

    public <T> BytesBuilder addBytes(T obj, Function<T, byte[]> mapper) {
        this.addBytes(mapper.apply(obj));
        return this;
    }

    public <T> BytesBuilder addBytes(Iterable<T> list, Function<T, byte[]> mapper) {
        list.forEach((? super T a) -> this.addBytes((byte[])mapper.apply(a)));
        return this;
    }

    public BytesBuilder addBytes(Stream<byte[]> stream) {
        stream.forEach(this::addBytes);
        return this;
    }

    public BytesBuilder addBit(boolean bitVal) {
        this.bitBuilder.addBit(bitVal);
        return this;
    }

    public BytesBuilder addBitRepeat(boolean bitVal, int repeatTimes) {
        this.bitBuilder.addBitRepeat(bitVal, repeatTimes);
        return this;
    }

    public BytesBuilder addBit(int bitVal) {
        this.bitBuilder.addBit(bitVal);
        return this;
    }

    public BytesBuilder addBitRepeat(int bitVal, int repeatTimes) {
        this.bitBuilder.addBitRepeat(bitVal, repeatTimes);
        return this;
    }

    public BytesBuilder addBits(int bitCnt, long val) {
        this.bitBuilder.addBits(bitCnt, val);
        return this;
    }

    public BytesBuilder addBits(List<Boolean> bits) {
        this.bitBuilder.addBits(bits);
        return this;
    }

    public BytesBuilder addBits(CharSequence bitsStr) {
        this.bitBuilder.addBits(bitsStr);
        return this;
    }

    protected BytesBuilder requireBitsFinished() {
        this.bitBuilder.requireFinished();
        return this;
    }

    public BytesBuilder addByteBySupplier(int times, IntUnaryOperator mapper) {
        for (int i = 0; i < times; ++i) {
            this.addByte(mapper.applyAsInt(i));
        }
        return this;
    }

    @Override
    public byte[] toBytes() {
        this.requireBitsFinished();
        return Arrays.copyOf(this.buf(), this.pos);
    }

    @Override
    public String toHex() {
        this.requireBitsFinished();
        return HexUtil.BytesToHex(this.buf(), 0, this.pos);
    }

    public IBytesRange toBytesRange() {
        this.requireBitsFinished();
        return SimpleByteArrayRange.of(() -> this.buf(), 0, this.pos);
    }

    public BytesBuilder forEach(IntByteConsumer consumer) {
        this.requireBitsFinished();
        for (int i = 0; i < this.pos; ++i) {
            consumer.accept(i, this.buf()[i] & 0xFF);
        }
        return this;
    }

    public int toIntResult(int beginVal, IntByteOperator mapper) {
        this.requireBitsFinished();
        int result = beginVal;
        for (int i = 0; i < this.pos; ++i) {
            result = mapper.apply(result, this.buf()[i] & 0xFF);
        }
        return result;
    }

    public long toLongResult(long beginVal, LongByteOperator mapper) {
        long ret = beginVal;
        for (int i = 0; i < this.pos; ++i) {
            ret = (byte)mapper.apply(ret, this.buf()[i] & 0xFF);
        }
        return ret;
    }

    public <T> T toResult(Function<IBytesRange, T> mapper) {
        this.requireBitsFinished();
        return mapper.apply(this.toBytesRange());
    }

    public void save(Path file) {
        this.requireBitsFinished();
        try {
            Files.write(file, this.toBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(HexUtil.BytesToMessage(this.toBytes()));
        if (this.bitBuilder.remainBitCnt() > 0) {
            build.append("+bits").append(this.bitBuilder.toString());
        }
        return build.toString();
    }
}

