/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.bytes.IBytesRange;
import cn.gongler.util.bytes.function.IntByteConsumer;
import cn.gongler.util.bytes.function.IntByteOperator;
import cn.gongler.util.bytes.function.LongByteOperator;
import java.io.InputStream;
import java.util.function.IntUnaryOperator;

public class Bytes {
    private static final long serialVersionUID = 1L;
    public static final byte[] EMPTY_BYTES = new byte[0];

    private Bytes() {
    }

    public static byte[] byteArray(String hex) {
        return BytesBuilder.of().addBytes(hex).toBytes();
    }

    public static byte[] byteArray(InputStream in) {
        return BytesBuilder.of().addByteStream(in).toBytes();
    }

    public static byte[] byteArray(int times, IntUnaryOperator mapper) {
        byte[] buf = new byte[times];
        for (int i = 0; i < times; ++i) {
            buf[i] = (byte)mapper.applyAsInt(i);
        }
        return buf;
    }

    public static byte[] fillArray(byte[] buf, int from, int times, IntUnaryOperator mapper) {
        for (int i = 0; i < times; ++i) {
            buf[from + i] = (byte)mapper.applyAsInt(i);
        }
        return buf;
    }

    public static byte[] forEach(byte[] buf, IntByteConsumer consumer) {
        for (int i = 0; i < buf.length; ++i) {
            consumer.accept(i, buf[i] & 0xFF);
        }
        return buf;
    }

    public static int toIntResult(byte[] buf, int beginVal, IntByteOperator mapper) {
        return Bytes.toIntResult(buf, 0, buf.length, beginVal, mapper);
    }

    public static int toIntResult(byte[] buf, int from, int byteCnt, int beginVal, IntByteOperator mapper) {
        int ret = beginVal;
        for (int i = 0; i < byteCnt; ++i) {
            ret = (byte)mapper.apply(ret, buf[from + i] & 0xFF);
        }
        return ret;
    }

    public static long toLongResult(byte[] buf, long beginVal, LongByteOperator mapper) {
        long ret = beginVal;
        for (int i = 0; i < buf.length; ++i) {
            ret = (byte)mapper.apply(ret, buf[i] & 0xFF);
        }
        return ret;
    }

    public static String toString(byte[] buf) {
        return Bytes.toString(buf, (CharSequence)"");
    }

    public static String toString(byte[] buf, CharSequence delimiter) {
        return HexUtil.BytesToHex(buf, delimiter);
    }

    public static String toString(byte[] buf, int from, int size) {
        return Bytes.toString(buf, from, size, "");
    }

    public static String toString(byte[] buf, int from, int size, CharSequence delimiter) {
        return HexUtil.BytesToHex(buf, from, size, delimiter);
    }

    public static String toString(IBytesRange bytesRange) {
        return Bytes.toString(bytesRange, (CharSequence)"");
    }

    public static String toString(IBytesRange bytesRange, CharSequence delimiter) {
        return HexUtil.BytesToHex(bytesRange, delimiter);
    }
}

