/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

public class BitUtil {
    private BitUtil() {
    }

    public static boolean getBit(long value, int bitIndex) {
        return (1L << bitIndex & value) != 0L;
    }

    public static long setBit(long value, int bitIndex, boolean bitVal) {
        return (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) & value | (long)((bitVal ? 1 : 0) << bitIndex);
    }

    public static boolean getBit(int value, int bitIndex) {
        return (1L << bitIndex & (long)value) != 0L;
    }

    public static int setBit(int value, int bitIndex, boolean bitVal) {
        return ~(1 << bitIndex) & value | (bitVal ? 1 : 0) << bitIndex;
    }

    public static boolean getBit(short value, int bitIndex) {
        return (1 << bitIndex & value) != 0;
    }

    public static short setBit(short value, int bitIndex, boolean bitVal) {
        return (short)(~(1 << bitIndex) & value | (bitVal ? 1 : 0) << bitIndex);
    }

    public static boolean getBit(byte value, int bitIndex) {
        return (1 << bitIndex & value) != 0;
    }

    public static byte setBit(byte value, int bitIndex, boolean bitVal) {
        return (byte)(~(1 << bitIndex) & value | (bitVal ? 1 : 0) << bitIndex);
    }

    public static int getBits(long value, int bitIndex, int bitCnt) {
        return (int)(value >>> bitIndex & (long)((1 << bitCnt) - 1));
    }

    public static long setBits(long value, int bitIndex, int bitCnt, int bitVal) {
        long mask = (1L << bitCnt) - 1L;
        return value & (mask ^ 0xFFFFFFFFFFFFFFFFL) | ((long)bitVal & mask) << bitIndex;
    }

    public static int setBits(int value, int bitIndex, int bitCnt, int bitsVal) {
        int mask = (1 << bitCnt) - 1 << bitIndex;
        return value & ~mask | (bitsVal & mask) << bitIndex;
    }

    public static byte setBits(byte value, int bitIndex, int bitCnt, int bitsVal) {
        int mask = (1 << bitCnt) - 1 << bitIndex;
        return (byte)(value & ~mask | (bitsVal & mask) << bitIndex);
    }

    public static short setBits(short value, int bitIndex, int bitCnt, int bitsVal) {
        int mask = (1 << bitCnt) - 1 << bitIndex;
        return (short)(value & ~mask | (bitsVal & mask) << bitIndex);
    }
}

