/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import cn.gongler.util.GonglerUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface IProperties {
    public static IProperties of(Function<String, String> mapper) {
        return mapper::apply;
    }

    public static IProperties of(Map<String, String> map) {
        return map::get;
    }

    public static IProperties of(URI uri) {
        String query = uri.getQuery();
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (query != null) {
            Arrays.stream(query.split("\\&")).forEach(a -> {
                String[] kv = a.split("\\=", 2);
                map.put(kv[0], kv[1]);
            });
        }
        return IProperties.of(map);
    }

    public static IProperties of(Properties prop) {
        return prop::getProperty;
    }

    public static IProperties of(Path propertiesFile) throws IOException {
        try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(propertiesFile.toFile()), StandardCharsets.UTF_8);){
            Properties prop = new Properties();
            prop.load(is);
            IProperties iProperties = IProperties.of(prop);
            return iProperties;
        }
    }

    public static IProperties of(Path propertiesFile, Consumer<Throwable> exceptionHandler) {
        try {
            return IProperties.of(propertiesFile);
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return IProperties.of(new Properties());
        }
    }

    public String getString(String var1);

    default public String getString(String key, String defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : valStr;
    }

    default public int getInt(String key) {
        return this.getInt(key, 0);
    }

    default public int getInt(String key, int defaultVal) {
        int val = defaultVal;
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : GonglerUtil.DecodeInt(valStr);
    }

    default public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    default public Integer getInteger(String key, Integer defaultVal) {
        Integer val = defaultVal;
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : GonglerUtil.DecodeInt(valStr);
    }

    default public Long getLong(String key) {
        return this.getLong(key, 0L);
    }

    default public Long getLong(String key, Long defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : GonglerUtil.DecodeLong(valStr);
    }

    default public Boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    default public Boolean getBoolean(String key, Boolean defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : Boolean.parseBoolean(valStr);
    }

    default public Duration getDuration(String key) {
        return this.getDuration(key, null);
    }

    default public Duration getBoolean(String key, Duration defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : Duration.parse(valStr);
    }

    default public List<Long> getLongs(String key) {
        return GonglerUtil.DecodeLongs(this.getString(key));
    }

    default public List<Integer> getIntegers(String key) {
        return GonglerUtil.DecodeIntegers(this.getString(key));
    }

    default public <T> List<T> getObjects(String key, T defaultVal, Function<String, T> converter) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? Collections.emptyList() : Arrays.stream(valStr.split(",")).map(converter).collect(Collectors.toList());
    }

    default public Duration getDuration(String key, Duration defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : Duration.parse(valStr);
    }

    default public LocalTime getLocalTime(String key, LocalTime defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : LocalTime.parse(valStr);
    }

    default public LocalDate getLocalDate(String key, LocalDate defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : LocalDate.parse(valStr);
    }

    default public LocalDateTime getLocalDateTime(String key) {
        return this.getLocalDateTime(key, null);
    }

    default public LocalDateTime getLocalDateTime(String key, LocalDateTime defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : LocalDateTime.parse(valStr);
    }

    default public OffsetDateTime getOffsetDateTime(String key, OffsetDateTime defaultVal) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : OffsetDateTime.parse(valStr);
    }

    default public <T> T getObject(String key, T defaultVal, Function<String, T> func) {
        String valStr = this.getString(key);
        return GonglerUtil.IsEmptyString(valStr) ? defaultVal : func.apply(valStr);
    }
}

