/*
 *
 *
 *
 */
package cn.gongler.util.tuple;

import java.util.StringJoiner;

/**
 * @author gongler
 */
public class Tuple4<F, S, T, F4> {

    private static final long serialVersionUID = -7639128013859560052L;//Tuple4
    private final F first;
    private final S second;
    private final T third;
    private final F4 forth;

    static <F, S, T, F4> Tuple4<F, S, T, F4> of(F first, S second, T third, F4 forth) {
        return new Tuple4<>(first, second, third, forth);
    }

    private Tuple4(F first, S second, T third, F4 forth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.forth = forth;
    }

    public F first() {
        return first;
    }

    public S second() {
        return second;
    }

    public T third() {
        return third;
    }

    public F4 forth() {
        return forth;
    }

    public int size() {
        return 4;
    }

    public F e1() {
        return first;
    }

    public S e2() {
        return second;
    }

    public T e3() {
        return third;
    }

    public F4 e4() {
        return forth;
    }

    @Override
    public String toString() {
        return new StringJoiner(",")
                .add(String.valueOf(first()))
                .add(String.valueOf(second()))
                .add(String.valueOf(third()))
                .add(String.valueOf(forth()))
                .toString();
    }
}
