/*
 *
 *
 *
 */
package cn.gongler.util.tuple;

import java.util.StringJoiner;

/**
 * @author gongler
 */
public class Tuple3<F, S, T> {

    private static final long serialVersionUID = -7639128018154527349L;//Tuple3
    private final F first;
    private final S second;
    private final T third;

    static <F, S, T> Tuple3<F, S, T> of(F first, S second, T third) {
        return new Tuple3<>(first, second, third);
    }

    private Tuple3(F first, S second, T third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public F first() {
        return first;
    }

    public S second() {
        return second;
    }

    public T third() {
        return third;
    }

    public int size() {
        return 3;
    }

    public F e1() {
        return first;
    }

    public S e2() {
        return second;
    }

    public T e3() {
        return third;
    }

    @Override
    public String toString() {
        return new StringJoiner(",")
                .add(String.valueOf(first()))
                .add(String.valueOf(second()))
                .add(String.valueOf(third()))
                .toString();
    }
}
