/*
 *
 *
 *
 */
package cn.gongler.util.tuple;

import java.util.StringJoiner;

/**
 * @author gongler
 */
public class Tuple2<F, S> {

    private static final long serialVersionUID = -7639128022449494646L;//Tuple2
    private final F e1;
    private final S e2;

    static <F, S> Tuple2<F, S> of(F first, S second) {
        return new Tuple2<>(first, second);
    }

    private Tuple2(F first, S second) {
        this.e1 = first;
        this.e2 = second;
    }

    public F first() {
        return e1;
    }

    public S second() {
        return e2;
    }

    public int size() {
        return 2;
    }

    public F e1() {
        return e1;
    }

    public S e2() {
        return e2;
    }

    @Override
    public String toString() {
        return new StringJoiner(",")
                .add(String.valueOf(first()))
                .add(String.valueOf(second()))
                .toString();
    }

}
