/*
 */
package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.LineUpDown;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;

/**
 * @author gongler
 */
public class Lowline {

    private static final long serialVersionUID = 8683820964875926888L;//2017-09-13 Lowline

    static final Lowline NULL = new Lowline(0);

    long lowlineId;

    long refLineId = 0;
    int lowlineSerial;

    //List<LineBusstop> busstopList = new ArrayList<LineBusstop>(50);
    final LineSide[] lineSides = {new LineSide(LineUpDown.LINE_UP), new LineSide(LineUpDown.LINE_DOWN)};//
    private String lowlineName = "lowlineName";

    public Lowline(long lowlineId) {
        this.lowlineId = lowlineId;
    }

    int getBusstopCnt(boolean upDown) {
        return lineSides[upDown ? 0 : 1].getBusstopCnt();
    }

    public long id() {
        return lowlineId;
    }

    int getLowLineSerial() {
        return lowlineSerial;
    }

    public LineSide getLineSide(LineUpDown upDown) {
        return lineSides[upDown.ordinal()];
    }

    public void appendBusstop(LineUpDown upDown, LineBusstop lineBusstop) {
        LineSide side = getLineSide(upDown);
        side.appendBusstop(lineBusstop);
        lineBusstop.setLineSide(side);
    }

    void clearBusstops() {
        for (LineSide lineSide : lineSides) {
            lineSide.clearBusstopList();
        }
    }

    void setParent(long lineId, int lineSubno) {
        this.refLineId = lineId;
        this.lowlineSerial = lineSubno;
    }

    void setName(String lowlineName) {
        this.lowlineName = lowlineName;
    }

    public LineSide getNextLineSide(LineSide lineSide) {
        LineUpDown reserve = LineUpDown.reverse(lineSide.upDown());
        LineSide nextLineSide = getLineSide(reserve);
        if (nextLineSide.getBusstopCnt() == 0) {
            nextLineSide = lineSide;
        }
        return nextLineSide;
    }

    //    long refScopeId = 0;
//    public void setScopeId(long scopeId){
//        this.refScopeId = scopeId;
//    }
//
//    IGeoScope refScope = null;
//    public void setScope(IGeoScope refScope){
//        this.refScope = refScope;
//    }
    public boolean existLineScope(Connection conn) throws SQLException {
        //return refScopeId>0;
        Scope geoScope = ScopeGroupFactory.of().scope(lowlineId);//TODO 目前采用简化设计：围栏ID即线路ID//.beforeAccessDb(conn)
        return geoScope != null;
    }

    public boolean inside(IGps gps, Connection conn) throws SQLException {
        return ScopeGroupFactory.of().inside(gps, lowlineId);//InsideHelper.inside(lowlineId, gps, conn);//目前采用简化设计：围栏ID即线路ID
    }

    @Override
    public String toString() {
        String builder = "\n " + this.getClass().getSimpleName() +
                "" + lowlineId +
                "," + lowlineName +
                "," + Arrays.toString(lineSides);//.append(",").append(refBusLine.getBusLineId())
        return builder;
    }

}
