package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.db.DbUtil;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.line.LineUpDown;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;

/**
 * 预留，未来可能使用。2011.04.27
 *
 * @author gongler
 */
public class LowLineFactory {

    private static final long serialVersionUID = 5017628608159705630L;//2017-09-13 LowLineFactory

    public Map<Long, Lowline> lowlineMap = new TreeMap<>();

    DataSource refDs = null;

    public LowLineFactory(DataSource ds) {
        this.refDs = ds;
    }

    public void load() throws SQLException {
        Connection conn = refDs.getConnection();
        load(conn);
    }

    public void load(Connection conn) throws SQLException {
//        ScopeGroup.LINESCOPE_SCOPEGROUP.load(conn);
//        ScopeGroup.OVERSPEED_SCOPEGROUP.load(conn);
//        ScopeGroup.BUSSTOPS_SCOPEGROUP.load(conn);
        ScopeGroupFactory.of().loadAllFromDb(conn, true);
        loadLine(conn);
    }

    static long getsublineKey(long lineId, int lineSubno) {
        return (lineId * 100) | (lineSubno % 100);//return (lineId<<8)|(lineSubno&0xFF);
    }

    static long getLowlineId(Map<Long, Long> lowlineMap, long lineId, int lineSubno) {
        Long ret = lowlineMap.get(getsublineKey(lineId, lineSubno));
        if (ret == null) {
            ret = 0L;
        }
        return ret;
    }

    private void loadLine(Connection conn) throws SQLException {
        final Map<Long, Long> tmpLowlineMap = new TreeMap<>();
        DbUtil.ExecuteQuery(conn, "select * from vw_lowline_map", new DbUtil.RowHandler() {

            Lowline busSubline = Lowline.NULL;

            @Override
            public void rowHandle(ResultSet rs, int rowIndex) throws SQLException {
                final long lineId = rs.getLong("LINE_NO");
                final int lineSubno = rs.getInt("LINE_SUBNO");
                final long lowlineId = rs.getLong("LOWLINE_NO");
                tmpLowlineMap.put(getsublineKey(lineId, lineSubno), lowlineId);
            }
        });
        //System.out.println("lowlineMap=" + tmpLowlineMap);

        DbUtil.ExecuteQuery(conn, "SELECT T1.*, T2.LINE_NAME, T3.BUSSTOP_NAME FROM BASE_LINE_BUSSTOP T1, BASE_LINE T2, BASE_BUSSTOP T3 WHERE T1.LINE_NO=T2.LINE_NO AND T1.BUSSTOP_NO=T3.BUSSTOP_NO ORDER BY T1.LINE_NO, T1.LINE_SUBNO, T1.UPDOWN, T1.BUSSTOP_SERIAL", new DbUtil.RowHandler() {

            //BusLine busLine = null;
            Lowline lastLowline = Lowline.NULL;

            @Override
            public void rowHandle(ResultSet rs, int rowIndex) throws SQLException {
                final long lineId = rs.getLong("LINE_NO");
                final int lineSubno = rs.getInt("LINE_SUBNO");
                final long lowlineId = getLowlineId(tmpLowlineMap, lineId, lineSubno);
                final int updown = rs.getInt("UPDOWN") - 1;//20110710debug 从外部取到的数据1，2用作上下行。
                final String LineName = rs.getString("LINE_NAME");
                final String busstopName = rs.getString("BUSSTOP_NAME");
                final long busstopId = rs.getLong("BUSSTOP_NO");

                //System.out.println(""+rowIndex+", "+busstopId+", "+busstopName);
                String lowlineName = LineName + "_" + lineSubno;//临时借用
                switchLineIfNeed(lowlineId, lowlineName, lineId, lineSubno, LineName);

                LineBusstop lineBusstop = new LineBusstop(busstopId, busstopName);
                lastLowline.appendBusstop(LineUpDown.parse(updown), lineBusstop);

            }

            @Override
            public void finished(int rowIndex) {
                switchLineIfNeed(-1, "", -1, -1, "");
            }

            private void switchLineIfNeed(long newLowlineId, String newLowlineName, long newLineId, int newLineSubno, String newLineName) {
                final Lowline lastLowline = this.lastLowline;
                final long lastLowlineId = lastLowline == null ? -1 : lastLowline.id();
                if (newLowlineId != lastLowlineId) {//20130711debug lastLowline.getLowlineId()) {
                    if (lastLowline != Lowline.NULL) {
                        lowlineMap.put(lastLowlineId, lastLowline);
                        //System.out.println("append to map: lowlineId" + lastLowlineId + "=" + lastLowline);
                    }
                    if (newLowlineId != -1) {//
                        Lowline nextLowline = new Lowline(newLowlineId);
                        nextLowline.setName(newLowlineName);
                        nextLowline.setParent(newLineId, newLineSubno);
                        this.lastLowline = nextLowline;
                    }
                }
            }
        });
        //System.out.println("" + lowlineMap);
    }

    public LineSide getLineSide(long lowlingId, LineUpDown upDown) {
        LineSide lineSide = null;
        Lowline busLine = getLowLine(lowlingId);
        if (busLine != null) {
            lineSide = busLine.getLineSide(upDown);
        }
        return lineSide;
    }

    public Lowline getLowLine(long lowlineId) {
        return lowlineMap.get(lowlineId);
    }

}
