/*
 */
package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.LineUpDown;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * @author gongler
 */
public class LineBusstop {// extends ScopeInfo{

    private static final long serialVersionUID = -8588439468922046706L;//2017-09-13 LineBusstop

    static LineBusstop NULL = new LineBusstop(0, "NULL");//20160914 (LineSide.NULL, 0, "NULL");
    long busstopId;
    String busstopName;
    LineSide refLineSide;
    int lineBusstopSerial;
    private int busstopType;

    long scopeId;

    //20160914    LineBusstop(LineSide lineSide, long busstopId, String busstopName) {
//        this.refLineSide = lineSide;
//        this.busstopName = busstopName;
//        this.busstopId = busstopId;
//    }
    public LineBusstop(long busstopId, String busstopName) {
        this.busstopName = busstopName;
        this.busstopId = busstopId;
        this.scopeId = busstopId;//简化模式。
    }

    LineBusstop scopeId(long scopeId) {//20160914add
        this.scopeId = scopeId;
        return this;
    }

    /**
     * @param serial from 1
     */
    public void setBusstopSerial(int serial) {
        this.lineBusstopSerial = serial;
    }

    public String getName() {
        return busstopName;
    }

    public int getBusstopType() {
        return busstopType;
    }

    public long getBusstopId() {
        return busstopId;
    }

    /**
     * @return from 1
     */
    public int getBusstopSerial() {
        return lineBusstopSerial;
    }

    int getBusstopRemain() {
        return refLineSide.getBusstopCnt() - lineBusstopSerial;
    }

    public boolean inside(IGps gps, Connection conn) throws SQLException {
        return ScopeGroupFactory.of().scope(busstopId).inside(gps);//.beforeAccessDb(conn)
    }

    public Scope getScope(Connection conn) throws SQLException {
        return ScopeGroupFactory.of().scope(busstopId);//.beforeAccessDb(conn)
    }

    @Override
    public String toString() {
        LineUpDown upDown = LineUpDown.LINE_UP;
        if (refLineSide != null) {
            upDown = refLineSide.upDown;
        }
        String builder = "{" + this.getClass().getSimpleName() +
                busstopId +
                "," + busstopName +
                "," + upDown +
                "," + lineBusstopSerial +
                "/" + (refLineSide == null ? "" : refLineSide.getBusstopCnt()) +
                //.append(",").append(scope)
                "}";
        return builder;
    }

    void setLineSide(LineSide side) {
        this.refLineSide = side;
    }

}
