package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.sgeo.gps.IGps;

public class BusstopState {

    private static final long serialVersionUID = 2724857337852164113L;//2017-09-13 BusstopState

    LineBusstop curBusstop = LineBusstop.NULL;
    boolean inBusstop = false;

    long fromTime = 0;
    IGps fromGps;
    long toTime = 0;//进站中该项无意义
    IGps toGps;

    public boolean isInBusstop() {
        return inBusstop;
    }

    public LineBusstop getBusstop() {
        return curBusstop;
    }

    public int reachBusstop(LineBusstop busstop, IGps gps) {
        this.curBusstop = busstop;
        this.inBusstop = true;
        fromTime = gps.gpsTime();
        fromGps = gps;
        return (int) (fromTime - toTime) / 1000;
    }

    public int leaveBusstop(LineBusstop busstop, IGps gps) {
        if (curBusstop == busstop && inBusstop) {
            this.inBusstop = false;
            toTime = gps.gpsTime();
            toGps = gps;
            return (int) (toTime - fromTime) / 1000;
        }
        return -1;
    }

    public long getFromTime() {
        return fromTime;
    }

}
