/*
 */
package cn.gongler.util.sgeo.line;

import cn.gongler.util.sgeo.geo.GeoUtil;
import cn.gongler.util.sgeo.gps.IGps;

import java.sql.Time;

/**
 * 只输出2坐标间距离（要处理漂移点对距离的影响）
 *
 * @author gongler
 */
class GpsIntervalDis implements IGpsDis {

    private static final long serialVersionUID = 7470603854726833473L;//2017-09-13 GpsIntervalDis

    private IGps lastValidGps = null;
    private double curGpsDis = 0;

    public GpsIntervalDis(IGps gps) {
        lastValidGps = gps;
        curGpsDis = 0;
    }

    public GpsIntervalDis() {
        this(null);
    }

    @Override
    public void reset(IGps gps) {
        lastValidGps = gps;
        curGpsDis = 0;
    }

    @Override
    public void pushGps(IGps gps) {
        if (gps == null) return;
        if (this.lastValidGps == null) {
            lastValidGps = gps;
            this.curGpsDis = 0;
            return;
        }
        // validGps<>null and gps<>null

        final double gpsDis = GeoUtil.GetDistance(this.lastValidGps, gps);
        final long timeDis = gps.gpsTime() - lastValidGps.gpsTime();
        final double hours = ((double) timeDis) / 1000d / 60d / 60d;
        final double moveSpeed = hours <= 0 ? Double.MAX_VALUE : gpsDis / hours;

        if (timeDis > 40 * 60 * 1000) {//如果间隔超过40分钟，认为是网络重连，时间越长，行驶路线与直线间误差迅速增大，公交甚至已经折返，路线误差将不可预测，不自动补公里。
            this.lastValidGps = gps;
            this.curGpsDis = 0;
            return;
        }

        if (moveSpeed > 200d) {//短间隔大距离漂移。
            this.lastValidGps = gps;
            this.curGpsDis = 0;
            return;
        }

        if (gpsDis > 30d) {//设置公里上限值。
            this.lastValidGps = gps;
            this.curGpsDis = 0;
            return;
        }

        //处理原地GPS摆动情况（假定前提为GPS速度都为0），不增加虚假公里。
        if (lastValidGps.gpsSpeed() == 0 && gps.gpsSpeed() == 0) {
            if (timeDis < 60 * 1000) {//less then 1 minute
                //this.lastValidGps = gps;
                this.curGpsDis = 0;
                return;
            }
        }

        this.curGpsDis = gpsDis;
        //debug
        fromGps = lastValidGps;
        toGps = gps;

        this.lastValidGps = gps;
    }

    IGps fromGps;
    IGps toGps;

    @Override
    public double getDistance() {
        return curGpsDis;
    }

    @Override
    public String toString() {
        String bd = "GpsDis=" + curGpsDis +
                ", " + new Time(fromTime()) +
                "~" + new Time(toTime());
        return bd;
    }

    @Override
    public long fromTime() {
        if (fromGps == null) return 0;
        return fromGps.gpsTime();
    }

    @Override
    public long toTime() {
        if (toGps == null) return 0;
        return toGps.gpsTime();
    }

}
