package cn.gongler.util.sgeo.gps;


import cn.gongler.util.sgeo.geo.GeoUtil;
import cn.gongler.util.sgeo.geo.IGeoPoint;
import cn.gongler.util.sgeo.geo.Scope;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author gongler
 */
public class GeoRender {

    private static final long serialVersionUID = 1L;


    private final Set<Scope> scopes = new HashSet<>();
    private final Map<Long, String> scopeNameMap = new HashMap<>();
    private final List<IGeoPoint> gpses = new ArrayList<>();

    public void draw(Scope scope, String name) {
        scopes.add(scope);
        scopeNameMap.put(scope.id(), name);
    }

    public void draw(IGeoPoint gps) {
        gpses.add(gps);
    }

    public BufferedImage render(int width, int height) {
        double jingduMin = 9999;
        double jingduMax = 0;
        double weiduMin = 9999;
        double weiduMax = 0;
        for (Scope scope : scopes) {
            for (IGeoPoint gps : scope) {
                jingduMin = Math.min(jingduMin, gps.gpsLng());
                jingduMax = Math.max(jingduMax, gps.gpsLng());
                weiduMin = Math.min(weiduMin, gps.gpsLat());
                weiduMax = Math.max(weiduMax, gps.gpsLat());
            }

        }
        for (IGeoPoint gps : gpses) {
            jingduMin = Math.min(jingduMin, gps.gpsLng());
            jingduMax = Math.max(jingduMax, gps.gpsLng());
            weiduMin = Math.min(weiduMin, gps.gpsLat());
            weiduMax = Math.max(weiduMax, gps.gpsLat());
        }

        setTranlate(jingduMin, weiduMin, jingduMax - jingduMin, weiduMax - weiduMin);
        setImgSize(width, height);

        int dis = (int) GeoUtil.GetDistance(jingduMin, weiduMin, jingduMax, weiduMax);
        //System.out.println("dis=" + dis);

        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        Graphics2D g2d = image.createGraphics();
        g2d.setBackground(Color.WHITE);
        g2d.clearRect(0, 0, width, height);

        g2d.setColor(Color.BLUE);
        g2d.drawString("dis: " + dis + "km", 0, 20);

        for (IGeoPoint gps : gpses) {
            drawLine(g2d, gps);
        }
        for (IGeoPoint gps : gpses) {
            drawPoint(g2d, gps);
        }

        for (Scope scope : scopes) {
            Polygon polygon = toPolygon(scope);
            g2d.setColor(Color.RED);
            g2d.drawPolygon(polygon);
            g2d.drawString(scopeNameMap.get(scope.id()), max(polygon.xpoints) + 4, max(polygon.ypoints) + 4);
        }
        return image;
    }

    private static int max(int[] vals) {
        int ret = 0;
        for (int val : vals) {
            ret = Math.max(val, ret);
        }
        return ret;
    }

    private static void SaveImg(BufferedImage image, Path pngFile) {
        try {
            ImageIO.write(image, "png", pngFile.toFile());
        } catch (IOException ex) {
            Logger.getLogger(GeoRender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void renderToFile(int width, int height, Path pngFile) {
        SaveImg(render(width, height), pngFile);
    }

    int oldX = 0;
    int oldY = 0;
    IGeoPoint oldGps = IGeoPoint.of(0, 0);
//    private void drawPoint(Graphics2D g2d, IGeoPoint gps) {
//        int x = getX(gps);
//        int y = getY(gps);
//        //System.out.println("drawPoint: "+x+", "+y);
//        if ( GeoUtil.GetDistance(oldGps, gps)< 1) {
//            g2d.setColor(Color.GRAY);
//            g2d.drawLine(x, y, oldX, oldY);
//        }else{
//            System.out.println("diskm="+GeoUtil.GetDistance(oldGps, gps));
//        }
//        oldGps = gps;
//        oldX = x;
//        oldY = y;
//     
//        g2d.setColor(Color.BLACK);
//        g2d.drawLine(x, y, x, y + 1);
//    }

    private void drawLine(Graphics2D g2d, IGeoPoint gps) {
        int x = getX(gps);
        int y = getY(gps);
        //System.out.println("drawPoint: "+x+", "+y);
        if (GeoUtil.GetDistance(oldGps, gps) < 1) {
            g2d.setColor(Color.GRAY);
            g2d.drawLine(x, y, oldX, oldY);
        } else {
            //System.out.println("diskm=" + GeoUtil.GetDistance(oldGps, gps));
        }
        oldGps = gps;
        oldX = x;
        oldY = y;
    }

    private void drawPoint(Graphics2D g2d, IGeoPoint gps) {
        int x = getX(gps);
        int y = getY(gps);
        g2d.setColor(Color.BLACK);
        g2d.drawLine(x, y, x, y + 1);
    }

    private Polygon toPolygon(Scope scope) {
        Polygon polygon = new Polygon();
        Iterator<IGeoPoint> iterator = scope.iterator();
        for (IGeoPoint gps : scope) {
            int x = getX(gps);
            int y = getY(gps);
            polygon.addPoint(x, y);
            //    System.out.println("add point to polygon: "+x+", "+y);
        }
        return polygon;
    }

    private double jingduMin = 9999;
    private double weiduMin = 9999;
    private double jingduWidth = 0;
    private double weiduWidth = 0;
    private double jingduBili;
    private double weiduBili;
    private int width;
    private int height;

    private void setTranlate(double jingduMin, double weiduMin, double jingduWidth, double weiduWidth) {
        this.jingduMin = jingduMin;
        this.weiduMin = weiduMin;
        this.jingduWidth = jingduWidth;
        this.weiduWidth = weiduWidth;
    }

    int getX(IGeoPoint gps) {
        return (int) ((gps.gpsLng() - jingduMin) * jingduBili);
    }

    int getY(IGeoPoint gps) {
        return (int) ((gps.gpsLat() - weiduMin) * weiduBili);
    }

    private void setImgSize(int width, int height) {
        this.width = width;
        this.height = height;
        jingduBili = width / jingduWidth;
        weiduBili = height / weiduWidth;

    }

}
