/*
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.sgeo.line.LineUpDown;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author gongler
 */
public class BusState {

    private static final long serialVersionUID = -4734468406198550257L;//2017-09-13 BusState

    final Map<String, Object> map = new ConcurrentHashMap<>();//20170912gongler//HashMap<>();
    private final long busId;
    private long lowLineId;
    private LineUpDown upDown = LineUpDown.LINE_UP;
    private boolean isInsideLine = true;

    BusState(long clientId) {
        this.busId = clientId;
    }

    public long getBusId() {
        return busId;
    }

    public long getLowlineId() {
        return this.lowLineId;
    }

    public LineUpDown upDown() {
        return this.upDown;
    }

    int busstopSerial = 0;//first busstopSerial =1

    public int getBusstopSerial() {
        return this.busstopSerial;
    }

    public BusState setBusstopSerial(int busstopSerial) {
        this.busstopSerial = busstopSerial;
        return this;
    }

    public BusState switchLine(long lowlineId, LineUpDown upDown) {
        this.lowLineId = lowlineId;
        this.upDown = upDown;
        busstopSerial = 0;
        return this;
    }

    public boolean insideLineScope() {
        return this.isInsideLine;
    }

    IGps leaveLineGps = null;

    public IGps getLeaveLineGps() {
        return leaveLineGps;
    }

    public void setLeaveLineGps(IGps gps) {
        this.leaveLineGps = gps;
    }

    private long driverId = 0;

    public void setDriverId(long driverId) {
        this.driverId = driverId;
    }

    public long getDriverId() {
        return driverId;
    }

    public Object getValue(String key) {
        return map.get(key);
    }

    public Object getValue(String key, Object defaultVal) {

        return map.getOrDefault(key, defaultVal);//PropUtil.GetObject(map, key, defaultVal);
    }

    public Object setValue(String key, Object value) {

        return map.put(key, value);//PropUtil.SetObject(map, key, value);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() +
                busId +
                ", D" + driverId +
                ", L" + lowLineId +
                ", " + upDown +
                ", " + busstopSerial;
    }

}
