/*
 */
package cn.gongler.util.sgeo.gps;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author gongler
 */
public class BusFactory {

    private static final long serialVersionUID = 1L;


    private static BusFactory factory = null;

    private final Map<Long, BusState> busMap = new ConcurrentHashMap<>();//20170831gongler HashMap();

    public static BusFactory getInstance() {
        if (factory == null) {
            factory = new BusFactory();
        }
        return factory;
    }

    private BusFactory() {
    }

    public BusState getBus(long busId) {
        BusState bus = busMap.get(busId);
        if (bus == null) {
            bus = new BusState(busId);
            busMap.put(busId, bus);
            //System.out.println("new Bus" + busId + ", " + bus.hashCode());
        }
        return bus;
    }

    public Iterable<BusState> getIterator() {
        return busMap.values();
    }

}
