/*
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroup;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.line.AreaMoveAction;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

import static cn.gongler.util.GonglerUtil.Close;

/**
 * 类场站区域事件
 *
 * @author gongler
 * @since 2016.09.21
 */
public class AreaEventChecker {

    private static final long serialVersionUID = 3607859424546611432L;//AreaEventChecker @since 2016-09-21

    private final static Map<Long, AreaEventChecker> GROUP_AREAEVENT_CHECKER_MAP = new ConcurrentSkipListMap();//gongleradd20160921<groupId, checker>

    public static AreaEventChecker of(long scopeGroupId) {//20140916add将来可用采用map缓存
        return GROUP_AREAEVENT_CHECKER_MAP.computeIfAbsent(scopeGroupId, AreaEventChecker::new);//gonglerdebug20160921 return new ScopeGroup(scopeGroupId);
    }

    public static AreaEventChecker CHANGZHAN() {//20140916add
        return of(ScopeGroup.CHANG_GROUPID);//gonglerdebug20160921 return new ScopeGroup(scopeGroupId);
    }

    public static AreaEventChecker CITY_AREA() {//20140916add襄阳出租车2012
        return of(ScopeGroup.CITYSCOPE_GROUPID);//gonglerdebug20160921 return new ScopeGroup(scopeGroupId);
    }

    private final long scopeGroupId;//20170912gongler private final ScopeGroup cityScopeGroup;
    private final ConcurrentMap<Long, Scope> busMap = new ConcurrentSkipListMap();


    private AreaEventChecker(long scopeGroupId) {
        this.scopeGroupId = scopeGroupId;//this.cityScopeGroup = ScopeGroupFactory.of().group(scopeGroup);
        //System.out.println("AreaEventChecker():scopeGroupId" + scopeGroupId);
    }

    private ScopeGroup scopeGroup() {//20170912gongler
        return ScopeGroupFactory.of().group(scopeGroupId);
    }

    private Scope currentScope(long busId) {
        return busMap.get(busId);
    }

    public void check(Connection conn, long busId, IGps gps) throws SQLException {
        Scope cur = currentScope(busId);
        ScopeGroupFactory.of();//.beforeAccessDb(conn);//20170907gongleradd
        if (cur != null) {
            if (!cur.inside(gps)) {
                leaveScope(conn, busId, gps, cur);
                busMap.remove(busId);
            }
        } else {
            Scope enterScope = scopeGroup().firstInside(gps);
            if (enterScope != null) {
                enterNextScope(conn, busId, gps, enterScope);
                busMap.put(busId, enterScope);
            }
        }
    }

    private void leaveScope(Connection conn, long busId, IGps gps, Scope cur) throws SQLException {
        dbProc(conn, busId, gps, cur, AreaMoveAction.LEAVE);
    }

    private void enterNextScope(Connection conn, long busId, IGps gps, Scope enterScope) throws SQLException {
        dbProc(conn, busId, gps, enterScope, AreaMoveAction.ENTER);
    }

    private void log(Object... items) {
        StringBuilder buf = new StringBuilder(1024);
        for (Object item : items) {
            buf.append(item);
        }
        //System.out.println(buf.toString());
    }

    private void dbProc(Connection conn, long busId, IGps gps, Scope scope, AreaMoveAction areaMoveAction) throws SQLException {
        //System.out.println("PRO_NETPACK_OVERSPEED: " + busId + ", " + gps + ", " + areaMoveAction + ", " + scopeInfo);
        log("PK_SCOPE.SCOPE_EVENT: ", busId, ", ", gps, ", ", areaMoveAction, ", ", scope);

        CallableStatement statement = null;
        try {
            String sql = "CALL PK_SCOPE.SCOPE_EVENT (?,?,?,?,?, ?,?,?,?,?) ";

            statement = conn.prepareCall(sql);
            int pos = 1;
            statement.setTimestamp(pos++, new Timestamp(gps.gpsTime())); //01
            statement.setLong(pos++, scope.id());            //02
            statement.setString(pos++, scope.name());             //03
            statement.setLong(pos++, scope.groupId());            //04
            statement.setInt(pos++, areaMoveAction.getValue());          //05
            statement.setLong(pos++, busId);                             //06
            statement.setDouble(pos++, gps.gpsLng());                   //07
            statement.setDouble(pos++, gps.gpsLat());                   //08
            statement.setInt(pos++, gps.gpsAngle());                     //09
            statement.setInt(pos++, gps.gpsSpeed());                     //10

            statement.execute();
            conn.commit();

        } finally {
            Close(statement);
        }
    }

//    public static void main(String[] args) {
//        class TestGps implements IGps {
//
//            double geoL;
//            double geoB;
//
//            TestGps(double geoL, double geoB) {
//                this.geoL = geoL;
//                this.geoB = geoB;
//                System.out.println(this);
//            }
//
//            @Override
//            public long gpsTime() {
//                return System.currentTimeMillis();
//            }
//
//            @Override
//            public int gpsAngle() {
//                return 0;
//            }
//
//            @Override
//            public int gpsSpeed() {
//                return 0;
//            }
//
//            @Override
//            public double gpsLng() {
//                return geoL;
//            }
//
//            @Override
//            public double gpsLat() {
//                return geoB;
//            }
//
//            @Override
//            public String toString() {
//                return "" + geoL + ", " + geoB;
//            }
//        }
//
//        Connection conn = null;
//        try {
//            Class.forName("oracle.jdbc.driver.OracleDriver"); // 加载驱动
//            conn = DriverManager.getConnection("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=58.19.183.21)(PORT=11522))(CONNECT_DATA=(SERVICE_NAME=xyczc)))", "TAXI_GPS", "TAXI_GPRS_XY");
//            AreaEventChecker.of(1).check(conn, 123, new TestGps(0.5, 0.5));
//            AreaEventChecker.of(1).check(conn, 123, new TestGps(0.5, 0.4));
//            AreaEventChecker.of(1).check(conn, 123, new TestGps(-0.5, -0.5));
//            AreaEventChecker.of(1).check(conn, 123, new TestGps(0.5, 0.3));
//            conn.commit();
//        } catch (Exception ex) {
//            Logger.getLogger(AreaEventChecker.class.getName()).log(Level.SEVERE, null, ex);
//            ex.printStackTrace();
//        } finally {
//            Close(conn);
//        }
//    }

}
