/*
 * 2013/02~2013/03 created for Sender(ver2).
 * 2013.04.22 debug：修正ignoredAckEvent()中空指针。
 * @author gongler
 */
package cn.gongler.util.resend.db;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.function.ExceptionConsumer;
import cn.gongler.util.resend.ISender;
import cn.gongler.util.resend.Resender;

import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;

/*
 * 2013.04.03 gongler SendBus 增加synchronized, dbCheckThread(new), resendWorkThread(expired), receiverThread(ack)
 */

/**
 * 重发间隔一样，顺序插入的重发服务器。
 * <p>
 * v1.0 2013.02.01
 *
 * @param <Pack>  pack
 * @param <Param> parameter
 * @param <Ack>   ack
 * @author gongler
 */
public class SendPackScanner<Pack, Param, Ack> implements Closeable {

    private static final long serialVersionUID = 1L;

    private final Resender<Pack, Param, Ack> busResender;
    private volatile boolean cancel = false;
    private int newPackHotPower;
    private Thread loaderThread;//private final Thread loaderThread = 
    private long sleepMillns = 200L;//500L;
    private final Object loadDelayLock = new Object();

    public Resender<Pack, Param, Ack> ref() {
        return busResender;
    }

    public SendPackScanner(Runnable initPackChecker, ExceptionConsumer<ISendPackRegister<Pack, Param>> packScanner, BiPredicate<Pack, Ack> ackChecker, ISender<Pack> realSender) {
//gongler20130408 为避免用户实现中异常抛出干扰了内部逻辑，而进行强制捕捉异常 this.sendEventListener = sender;
        busResender = new Resender(ackChecker, realSender);
        GonglerUtil.StartDaemonThread("dbloaderThread", () -> {//数据库定时查询
            if (initPackChecker != null) {
                initPackChecker.run();
            }
            ISendPackRegister<Pack, Param> sendPackRegister = (Long busId, Pack pack, LocalDateTime expiredTime, boolean waitAck, Param param) -> {
                busResender.add(busId, pack, expiredTime, waitAck, param);//busResender.add(busId, pack, expiredTime, waitAck, sender1, obj);
                newPackHotPower++;
            };
            while (!cancel) {
                try {
                    newPackHotPower /= 2;//packCountInTurn = 0;
                    packScanner.accept(sendPackRegister);//sendEventListener.accept(busResenderDelegater);
                } catch (Throwable e) {//20141104 Exception e) {
                    e.printStackTrace();
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(sleepMillns);//20141104 Thread.sleep(500);//延期执行，避免过于频繁访问数据库
                    if (newPackHotPower == 0) {
                        synchronized (loadDelayLock) {
                            loadDelayLock.wait(1000 * 1);//20160803 5秒终归有点长，除非确保会唤醒。//20140324未来尝试改成5s如何？//loadDelayLock.wait(1000);//0.2seconds
                        }
                    }
                } catch (InterruptedException ex) {
                    //20141020 Logger.getLogger(SendServer.class.getName()).log(Level.SEVERE, null, ex);
                    cancel = true;
                    ex.printStackTrace();
                }
            }
        });
    }

    public void ack(Long busId, Ack ackPack) {
        busResender.ack(busId, ackPack);
    }

    /**
     * 如果正在等待数据，则通知可以检测一次。如果运行中，则忽略。
     */
    public void notifyRecheck() {
        synchronized (loadDelayLock) {
            loadDelayLock.notify();
        }
    }

    public Resender<Pack, Param, Ack> busResender() {
        return busResender;
    }

    @Override
    public void close() throws IOException {
        cancel = true;
        loaderThread.interrupt();
        busResender.close();
        //loader.close();
    }

    public interface ISendPackRegister<Pack, Param> {

        void add(Long busId, Pack pack, LocalDateTime expiredTime, boolean waitAck, Param param);
    }

    public static void main(String[] args) {

    }
}
