/*
 *
 *
 *
 */
package cn.gongler.util.resend.db;

/**
 * @author gongler
 */
public interface IAckPack extends ISendPack {

    int refPackCmd();

    int refPackSerial();

    int ackCode();

    /**
     * 应答指令流水号并没有意义，所以定义一个默认值即可。
     *
     * @return result
     */
    @Override
    default int packSerial() {
        return 0;
    }

    default boolean isAckOf(ISendPack refPack) {
        return refPackCmd() == refPack.packCmd() && refPackSerial() == refPack.packSerial();
    }
}
