/*
 *
 *
 *
 */
package cn.gongler.util.resend;

import java.time.Duration;
import java.time.LocalDateTime;

/**
 * @author gongler
 */
public interface ISendContext {

    int sendTimes();

    LocalDateTime createTime();

    LocalDateTime firstSendTime();

    LocalDateTime lastSendTime();

    LocalDateTime finishTime();

    default Duration duration() {
        if (firstSendTime() != null && finishTime() != null) {
            return Duration.between(firstSendTime(), finishTime());
        } else {
            return null;
        }
    }

    SendState sendState();

    enum SendState {
        WAITING,
        SENDING,
        SENT_SUCESS,
        SENT_FAILTURE
    }
}
