/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.30
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 键值对列表
 * <p>
 * [7.1.14　位置信息汇报]中的附加参数；[7.1.8　设置终端参数]中的参数键值表。 共同点：KEY：参数ID：DWORD（8.8
 * 设置终端参数）,BYTE（8.12　位置信息汇报）， [参数值]前含[参数长度](BYTE)
 *
 * @author gongler
 */
public class ParamMapType extends ItemType<ParamMapType> {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    protected final Map<Long, ItemType> paramTypeMap = new TreeMap<>();//protected final Map<Ingeter, ItemType> paramTypeMap = new TreeMap<>();//20150330 未来可能为了支持动态扩展调整，改用List

    public Map<Long, String> toNameMap() {
        return paramTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, a -> a.getValue().name()));
    }

    int headerBytes = 1;//GPS包附加信息，是0.

    public ParamMapType headerSize(int headerSize) {
        this.headerBytes = headerSize;
        return this;
    }

    int KeyBytes = 1;
    static final Map<Long, Item> INIT_VAL = Collections.EMPTY_MAP;

    public ParamMapType(int keyBytes, String name) {
        super(name);//super("STRING");
        this.KeyBytes = keyBytes;
    }

    public ParamMapType add(long key, ItemType itemType) {
        ItemType old = paramTypeMap.put(key, itemType);
        if (old != null) {
            throw new IllegalArgumentException("ParamMapType.key " + key + " has repeated:");
        }
        return this;
    }

//    public ParamMapType add(Map<Long, ItemType> typeMap) {
//        this.paramTypeMap.putAll(typeMap);
//        return this;
//    }

    /**
     * @return item
     */
    @Override
    public Item create() {
        //return new ParamMapItem(this, new TreeMap<>());
        Map<Long, Item> params = new TreeMap<>();
        //wanghg20190531 paramTypeMap.forEach((k, v) -> params.put(k, v.create()));//wanghg20190531add
        return _newItem(params);
    }

    ItemType paramType(long key) {
        return paramTypeMap.get(key);
    }

    private Map<Long, Item> _newValue() {
        return new TreeMap<>();
    }

    @Override
    public Item load(Scanner in) {//待测试。
        int paramsSize = headerBytes == 0 ? Integer.MAX_VALUE : in.nextInt();//in.loadUnsignedByte();
        Map<Long, Item> params = _newValue();
        for (int i = 0; (headerBytes > 0 && i < paramsSize) || (headerBytes == 0 && in.hasNext()); i++) {
            long key = in.nextLong();
            ItemType paramType = this.paramTypeMap.get(key);
            if (paramType == null) {
                throw new IllegalArgumentException("Unknown Map.Key:" + key);//如果遇到未知类型（无法识别复杂结构），则不再解析后继键值对。
            }
            Item paramItem = paramType.load(in);
            params.put(key, paramItem);
        }
        return _newItem(params);
    }

    @Override
    public Item load(Iterator<Object> in) {//待测试。
        int paramsSize = headerBytes == 0 ? Integer.MAX_VALUE : ((Number) in.next()).intValue();//in.loadUnsignedByte();
        Map<Long, Item> params = _newValue();
        for (int i = 0; (headerBytes > 0 && i < paramsSize) || (headerBytes == 0 && in.hasNext()); i++) {
            long key = ((Number) in.next()).longValue();
            ItemType paramType = this.paramTypeMap.get(key);
            if (paramType == null) {
                throw new IllegalArgumentException("Unknown Map.Key:" + key);//如果遇到未知类型（无法识别复杂结构），则不再解析后继键值对。
            }
            Item paramItem = paramType.load(in);
            params.put(key, paramItem);
        }
        return _newItem(params);
    }

    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        int paramsSize = headerBytes == 0 ? Integer.MAX_VALUE : in.loadUnsignedByte();//in.loadUnsignedByte();
        Map<Long, Item> params = _newValue();
        for (int i = 0; (headerBytes > 0 && i < paramsSize) || (headerBytes == 0 && in.remainBytesCount() > 0); i++) {
            long key = in.loadLong(this.KeyBytes);
            BytesLoader valueReader = in.loadBytesLoader(-1);//负值：绝对值是头的长度；正值：定长数据块的字节数。0：剩余
            ItemType paramType = this.paramTypeMap.computeIfAbsent(key, k -> BYTES(valueReader.remainBytesCount(), "unknownKey" + k));
            Item paramItem = paramType.load(valueReader);//兼容变长字符串缺\0的情况
            params.put(key, paramItem);
        }
        return _newItem(params);
    }

    /**
     * @param itemValue itemValue
     * @param build     builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof Map) {
            Map<Long, Item> params = (Map<Long, Item>) itemValue;
            int itemSize = params.size();
            build.addNum(headerBytes, itemSize);//build.addByte(itemSize);//build.addByte(len);
            params.forEach((k, v) -> {
                build.addNum(KeyBytes, k);
                BytesBuilder valBuild = BytesBuilder.of();
                paramType(k).toBytes(v, valBuild);
                byte[] valBytes = valBuild.toBytes();
                build.addByte(valBytes.length);
                build.addBytes(valBytes);
            });
        }
    }

    @Override
    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        Item item = (Item) itemValue;//wanghgadd20190620
        Map<Long, Item> map = item.mapValue();
        build.add(map.size());//len
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach((entry) -> build.add(entry.getKey()).add(entry.getValue()));
    }

    //    @Override
//    protected Object defaultValue() {
//        return INIT_VAL;
//    }
    @Override
    protected Class insideValueClass() {
        return Map.class;
    }

    public String keyName(long key) {
        String hex = Long.toHexString(key);
        ItemType paramType = this.paramTypeMap.get(key);
        return paramType != null ? paramType.name() + "(0x" + hex + ")" : "key_0x" + hex;
    }

    /**
     * @param itemValue itemValue
     * @return string
     */
    @Override
    public String toString(Object itemValue) {
        if (itemValue != null) {
            Map<Long, Item> params = (Map<Long, Item>) itemValue;
            return params.entrySet().stream().map(e -> keyName(e.getKey()) + ":" + e.getValue())
                    .collect(Collectors.joining(",", "{", "}"));
        } else {
            return "null";
        }
    }

    @Override
    public int dbParamCount() {
        //视频中值出现复杂值结构return 2;//key and value
        return 1;//作为1个长字符串传入数据库: k1:v1|k2:v2|k3:a:b:c  允许值中出现“:”，但尚不允许出现“|”
    }

    /**
     * @param item      item
     * @param statement CallableStatement
     * @param pos       pos
     * @return count
     * @throws SQLException SQLException
     */
    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, item.formatFlatObjects());
        return 1;
    }

    @Override
    public List<? extends ItemType> flatItemTypes() {
        return Collections.singletonList(STR(0, "键值列表"));//dbItemTypes;
    }

    @Override
    protected Item getSubitemImpl(Item map, int key) {//wanghg20190531add
        Map<Long, Item> mapItem = (Map<Long, Item>) map.getValue();
        Item subItem = mapItem.computeIfAbsent((long) key, k -> paramTypeMap.getOrDefault(k, REMAIN_BYTES("未知参数")).create());
        return subItem;
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }


}
