/*
 */
package cn.gongler.util.protocol.itemtype;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author gongler
 */
class IteratorBuilder<T> implements Iterable<T> {

    private static final long serialVersionUID = 1L;

    List<T> list = new ArrayList();

    public IteratorBuilder<T> add(T obj) {
        list.add(obj);
        return this;
    }

    public IteratorBuilder<T> add(T... objs) {
        list.addAll(Arrays.asList(objs));
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return list.iterator();
    }

    public String toString(CharSequence delimiter) {
        return list.stream().map(a -> Objects.toString(a, "")).collect(Collectors.joining(delimiter));
    }

    @Override
    public String toString() {
        return list.toString();
    }

}
