/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.30
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author gongler
 */
public class ItemTypeStruct extends ItemType<ItemTypeStruct> {

    private static final long serialVersionUID = 1L;

//    public final static ItemTypeStruct 视频参数设置T3 = new ItemTypeStruct(
//            "视频参数设置T3"//
//            , BYTE("实时流编码模式").description("100～127：自定义")
//                .valueNote(0, "CBR（固定码率）")
//                .valueNote(1, "VBR（可变码率）")
//                .valueNote(2, "ABR（平均码率）")
//            , BYTE("实时流分辨率")//
//            , WORD("实时流关键帧间隔")//范围1～1000
//            , BYTE("实时流目标帧率")
//            , DWORD("实时流关键帧间隔")
//            , BYTE("实时流目标帧率")
//            , BYTE("实时流目标码率")
//            , WORD("存储流关键帧间隔")
//            , BYTE("存储流目标帧率")
//            , DWORD("存储流目标码率")
//            , BYTE("OSD字幕叠加设置").description("按位设置：0表示不叠加，1表示叠加").显示进制(16)
//                .bit(0, "叠加日期")
//                .bit(1, "叠加时间")
//                .bit(2, "叠加车牌号码")
//                .bit(3, "叠加经纬度")
//                .bit(4, "叠加行驶记录速度")
//                .bit(5, "叠加卫星定位速度")
//                .bit(6, "叠加连续驾驶时间")
//    );
//
//    public final static ItemType 音视频监控逻辑通道号_TC1 = BYTE("表C.1 音视频监控逻辑通道号")
//            .valueNote(1, "视频/驾驶员")
//            .valueNote(2, "视频/车辆正前方")
//            .valueNote(3, "视频/前车门")
//            .valueNote(4, "视频/车厢前部")
//            .valueNote(5, "视频/车厢后部")
//            .valueNote(6, "视频/后车门")
//            .valueNote(7, "视频/行李舱")
//            .valueNote(8, "视频/车辆左侧")
//            .valueNote(9, "视频/车辆右侧")
//            .valueNote(10, "视频/车辆正后方")
//            .valueNote(11, "视频/车厢中部")
//            .valueNote(12, "视频/中车门")
//            .valueNote(13, "视频/驾驶席车门")
//            .valueNote(17, "音频/驾驶员")
//            .valueNote(20, "音频/车厢前部")
//            .valueNote(21, "音频/车厢后部");
//
//    public final static ItemTypeStruct 音视频通道对照表T5 = new ItemTypeStruct(
//            "音视频通道对照表T5"
//            , BYTE("物理通道号").description("从1开始")
//            , 音视频监控逻辑通道号_TC1//BYTE("逻辑通道号").description("参见附表C.1")
//            , BYTE("通道类型")
//                .valueNote(0,"视频")
//                .valueNote(1,"音频")
//            , BYTE("是否连接云台或启用音频输出")
//                .description("视频通道表示是否连接云台音频通道表示是否启用音频输出")
//                .valueNote(0,"未连接或未启用")
//                .valueNote(1,"连接或启用")
//    );
//
////            , BYTE("视频通道总数").description("T4_n")
////            , BYTE("音频通道总数").description("T4_m")
////            , LIST("音视频通道对照表T5", 音视频通道对照表T5)//TODO
//    /**
//     * 头部2字节分别存放音视频通道数的特殊列表结构（BYTE("视频通道总数")， BYTE("音频通道总数")，...）。由于特殊，使用了专用定制类ListTypeOfTable4。
//     */
//    public final static ListItemType 音视频通道列表T4 = new ListTypeOfTable4("音视频通道列表T4", 音视频通道对照表T5);//TODO
//
//
//    public final static ItemTypeStruct 单独视频通道参数设置T7 = new ItemTypeStruct(
//            "单独视频通道参数设置T7"
//            , 音视频监控逻辑通道号_TC1//BYTE("逻辑通道号").description("参见附表C.1")
//            , BYTE("实时流编码模式").description("100～127：自定义")
//                .valueNote(0, "CBR（固定码率）")
//                .valueNote(1, "VBR（可变码率）")
//                .valueNote(2, "ABR（平均码率）")
//            , BYTE("实时流分辨率")
//                .valueNote(0, "CIF")
//                .valueNote(1, "D1")
//                .valueNote(2, "QCIF")
//                .valueNote(3, "VGA")
//                .valueNote(4, "QVGA")
//                .valueNote(5, "720P")
//                .valueNote(6, "1080P")
//                .valueNote(7, "WD1")
//                .valueNote(8, "WCIF")
//            , WORD("实时流关键帧间隔").description("范围1～1000")
//            , BYTE("实时流目标帧率").description("范围1～30帧/秒")
//            , DWORD("实时流目标码率").description("单位kbps")
//            , BYTE("存储流编码模式").description("100～127：自定义")
//                .valueNote(0, "CBR（固定码率）")
//                .valueNote(1, "VBR（可变码率）")
//                .valueNote(2, "ABR（平均码率）")
//            , BYTE("存储流分辨率")
//                .valueNote(0, "CIF")
//                .valueNote(1, "D1")
//                .valueNote(2, "QCIF")
//                .valueNote(3, "VGA")
//                .valueNote(4, "QVGA")
//                .valueNote(5, "720P")
//                .valueNote(6, "1080P")
//                .valueNote(7, "WD1")
//                .valueNote(8, "WCIF")
//            , WORD("存储流关键帧间隔").description("范围1～1000")
//            , BYTE("存储流目标帧率").description("范围1～30帧/秒")
//            , DWORD("存储流目标码率").description("单位kbps")
//            , BYTE("OSD叠加设置").description("按位设置：0表示不叠加，1表示叠加").显示进制(16)
//                .bit(0, "叠加日期")
//                .bit(1, "叠加时间")
//                .bit(2, "叠加车牌号码")
//                .bit(3, "叠加经纬度")
//                .bit(4, "叠加行驶记录速度")
//                .bit(5, "叠加卫星定位速度")
//                .bit(6, "叠加连续驾驶时间")
//    );
//
//    public final static ItemType 单独视频通道参数设置列表T6 = LIST("单独视频通道参数设置列表T6", 单独视频通道参数设置T7);


    public final ItemType[] itemTypes;

    /**
     * @param name      name
     * @param itemTypes itemTypes
     */
    public ItemTypeStruct(String name, ItemType... itemTypes) {
        super(name);
        this.itemTypes = itemTypes;
    }

    private Item[] _newValue() {
        return new Item[itemTypes.length];
    }

    @Override
    public Item load(BytesLoader in) {
        Item[] items = _newValue();
        for (int i = 0; i < itemTypes.length; i++) {
            items[i] = itemTypes[i].load(in);
        }
        return _newItem(items);
    }

    @Override
    public Item load(Scanner in) {
        Item[] items = _newValue();
        for (int i = 0; i < itemTypes.length; i++) {
            items[i] = itemTypes[i].load(in);//System.out.println(itemTypes[i]+"["+i+"] "+items[i]);
        }
        return _newItem(items);
    }

    @Override
    public Item load(Iterator<Object> in) {
        Item[] items = _newValue();
        for (int i = 0; i < itemTypes.length; i++) {
            items[i] = itemTypes[i].load(in);
        }
        return _newItem(items);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof Item[]) {
            Item[] items = (Item[]) itemValue;
            //2022年2月10日17:01:05 废弃 build.setBitValueCnt(itemTypes.length);
            for (int i = 0; i < itemTypes.length; i++) {
                itemTypes[i].toBytes(items[i], build);
            }
        }
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        int beginPos = pos;
        Object itemValue = item.getValue();
        if (itemValue instanceof Item[]) {
            for (Item subitem : (Item[]) itemValue) {
                //System.out.println("" + pos + ", " + subitem.itemType());
                pos += subitem.statementParam(statement, pos);
            }
        }
        return pos - beginPos;
    }

    @Override
    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        if (itemValue instanceof Item[]) {
            for (Item subitem : (Item[]) itemValue) {
                subitem.toFlatObject(build);
            }
        }
    }

    @Override
    public Item create() {
        Item[] items = new Item[itemTypes.length];
        for (int i = 0; i < itemTypes.length; i++) {
            items[i] = itemTypes[i].create();
        }
        return _newItem(items);
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue != null) {
            Item[] items = (Item[]) itemValue;
            return Arrays.stream(items)
                    .map(item -> item.itemType().name() + ":" + item)//wanghg20190719为了方便解读GPS中过站附件信息增加项名 .map(String::valueOf)
                    .collect(Collectors.joining(",", "{", "}"));
        } else {
            return "null";
        }
    }//    @Override
//    protected Object defaultValue() {
//        return null;
//    }

    @Override
    protected Class insideValueClass() {
        return Item[].class;
    }

    @Override
    public int dbParamCount() {
        //return 1;//默认类型是1个，但列表时是多个。
        int sum = Arrays.stream(itemTypes).mapToInt(ItemType::dbParamCount).sum();//int cnt = this.itemTypes.length;
        return sum;
    }

    @Override
    public List<ItemType> flatItemTypes() {
        List<ItemType> ret = new ArrayList(Arrays.asList(itemTypes));
        return ret;
    }

    public ItemType get(int index) {
        return itemTypes[index];
    }

    /**
     * 便利接口，效率慢，不推荐频繁调用
     *
     * @param subItemTypeName subItemTypeName
     * @return itemType
     */
    public ItemType get(String subItemTypeName) {
        for (ItemType type : itemTypes) {
            if (type.name().equalsIgnoreCase(subItemTypeName)) {
                return type;
            }
        }
        throw new IllegalArgumentException("No exist: " + subItemTypeName);
    }

    @Override
    protected Item[] itemValue(Item item) {//可以在此转型到具体类型。也可以在此统一合法性监测。
        return (Item[]) item.getValue();
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        return itemValue(item)[key];
    }

    ////////////////////////////////////////////////////////////////////////////
    //
    private static class ListTypeOfTable4 extends ListItemType {//针对《表4：音视频通道列表》不规范的结构定制。

//            , BYTE("视频通道总数").description("T4_n")
//            , BYTE("音频通道总数").description("T4_m")
//            , LIST("音视频通道对照表T5", 音视频通道对照表T5)//TODO   

        public ListTypeOfTable4(String name, ItemType subItemType) {
            super(name, subItemType);//super("STRING");
        }

        @Override
        public Item load(Scanner in) {//待测试。
            int vsize = in.nextInt();
            int asize = in.nextInt();
            int size = vsize + asize;

            List<Item> groups = _newValue();//new ArrayList();
            for (int i = 0; i < size; i++) {
                groups.add(subItemType.load(in));
            }
            return _newItem(groups);
        }

        @Override
        public Item load(BytesLoader in) {
            int vsize = in.loadUnsignedByte();
            int asize = in.loadUnsignedByte();
            int len = vsize + asize;

            List<Item> groups = _newValue();//new ArrayList();
            for (int i = 0; i < len; i++) {
                groups.add(subItemType.load(in));
            }
            return _newItem(groups);
        }

        @Override
        public Item load(Iterator<Object> in) {
            int vsize = ((Number) in.next()).intValue();
            int asize = ((Number) in.next()).intValue();
            int len = vsize + asize;
            List<Item> groups = _newValue();//new ArrayList();
            for (int i = 0; i < len; i++) {
                Item subItem = subItemType.load(in);
                groups.add(subItem);
            }
            return _newItem(groups);
        }

        @Override
        public void toBytes(Object itemValue, BytesBuilder build) {
//            if (itemValue instanceof List) {
//                List<Item> groups = (List) itemValue;
//                int vsize = 0;
//                int asize = 0;
//                for(Item item: groups){
//                    int channleType = 音视频通道对照表T5.getSubitemImpl(item, 2).intValue();//2:通道类型 0：视频；1：音频
//                    switch(channleType){
//                        case 0://v
//                            vsize++;
//                            break;
//                        case 1://a
//                            asize++;
//                            break;
//                        default:
//                            throw new IllegalArgumentException("Unknown channel type: "+channleType);
//                    }
//                }
//                build.addByte(vsize);
//                build.addByte(asize);
//                for (Item item : groups) {
//                    item.toBytes(build);//item.toBytes(item, build);
//                }
//            }
        }

    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }


}
