/*
 * Tcps Protocol808_2015 Server
 * created by gongler at 2015.04.08
 *
 */
package cn.gongler.util.protocol.itemtype;


import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Scanner;

/**
 * @author gongler
 */
public class BcdItemTypeAsString extends ItemType<BcdItemTypeAsString> {

    private static final long serialVersionUID = 1L;

    private final int bytes;
    private final String INIT_VAL;

    public BcdItemTypeAsString(int bytes, String name) {
        super(name);//super("BYTE[]");
        this.bytes = bytes;
        char[] chars = new char[bytes * 2];
        Arrays.fill(chars, '0');
        INIT_VAL = new String(chars);//new byte[bytes];
    }

    /**
     * @return item
     */
    @Override
    public Item create() {
        return _newItem(INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
        String value = in.next();
        return _newItem(value);
    }

    /**
     * @param in loader
     * @return item
     */
    @Override
    public Item load(BytesLoader in) {
        final byte[] buf;
        if (bytes == 0) {
            buf = in.loadRemainBytes();
        } else {
            final int len;
            if (bytes < 0) {
                len = in.loadUnsignedByte();
            } else {
                len = bytes;
            }

            buf = new byte[len];
            for (int i = 0; i < len; i++) {
                buf[i] = (byte) in.loadUnsignedByte();
            }
        }
        return _newItem(Bytes2Hex(buf));
    }

    private String align(String bcdStr) {//前补0，超长时拒绝
        char[] chars = new char[bytes * 2];
        Arrays.fill(chars, '0');
        char[] org = bcdStr.toCharArray();
        if (chars.length < org.length) {
            throw new IllegalArgumentException("bcd string is too long:" + bcdStr);
        }
        if (chars.length == org.length) {
            return bcdStr;
        } else {
            int newFrom = chars.length - org.length;
            Arrays.fill(chars, 0, newFrom, '0');
            System.arraycopy(org, 0, chars, newFrom, org.length);
            return new String(chars);
        }
    }

    /**
     * @param itemValue itemValue
     * @param build     builder
     */
    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        String bcdStr = (String) itemValue;
        bcdStr = align(bcdStr);
        byte[] byteBlock = Hex2Bytes(bcdStr);//
        if (bytes < 0) {
            build.addByte(byteBlock.length);//len byte
        } else if (bytes > 0) {
            if (byteBlock.length != bytes) {
                byteBlock = Arrays.copyOf(byteBlock, bytes);
            }
        } else if (bytes == 0) {
            //原样输出
        }
        build.addBytes(byteBlock);
    }

    @Override
    protected Class insideValueClass() {
        return String.class;
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, toString(item.getValue()));
        return 1;
    }

    static byte[] Hex2Bytes(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        for (int i = 0; i < chars.length; i += 2) {
            int hi = Character.digit(chars[i], 16);
            int lo = Character.digit(chars[i + 1], 16);
            bytes[i / 2] = (byte) (hi << 4 | lo);
        }
        return bytes;
    }

    static String Bytes2Hex(byte[] bytes) {
        final char[] digits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder build = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            build.append(digits[(aByte >>> 4) & 0x0F]);
            build.append(digits[aByte & 0x0F]);
        }
        return build.toString();
    }

//    /**
//     * @param args
//     */
//    public static void main(String[] args) {
////        for (int i = 1; i < 8; i++) {
////            System.out.println("test i" + i);
////            BcdItemTypeAsString type = new BcdItemTypeAsString(i, "name" + i);
////            BytesBuilder build = new BytesBuilder();
////            type.toBytes(new byte[i], build);
////            System.out.println("" + build);
////        }
//
//        System.out.println("" + new BcdItemTypeAsString(10, "ICCID").align("890"));
//        System.out.println("" + new BcdItemTypeAsString(10, "ICCID").align("12345678901234567890"));
//        System.out.println("" + new BcdItemTypeAsString(10, "ICCID").align("1234567890123456789099999999999999999999999"));
//
//    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {//wanghg20190531add
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
//7E0107004801234567890100030047313233343558352D494949000000000000000000000000000030303832303030898600211915760111750F535654372E3832302E3938332E3031095431353035323637350101A57E