package cn.gongler.util.math;

/**
 * 鉴于java.lang.Math关于三角函数都是利用弧度计算。为了方便大家使用，本类提供角度三角函数按本。
 */
public class DegreeMath {

    private static final long serialVersionUID = 1L;

    private DegreeMath() {
    }

    /**
     * 正弦函数
     *
     * @param degree 角度值
     * @return 正弦值
     */
    public static double sin(double degree) {
        return Math.sin(Math.toRadians(degree));
    }

    /**
     * 余弦函数
     *
     * @param degree 角度值
     * @return 余弦值
     */
    public static double cos(double degree) {

        return Math.cos(Math.toRadians(degree));
    }

    /**
     * 正切函数
     *
     * @param degree 角度值
     * @return 正切值
     */
    public static double tan(double degree) {
        return Math.tan(Math.toRadians(degree));
    }

    /**
     * 反正弦函数
     *
     * @param value 正弦值
     * @return 角度
     */
    public static double asin(double value) {
        return Math.toDegrees(Math.asin(value));
    }

    /**
     * 反余弦函数
     *
     * @param value 余弦值
     * @return 角度
     */
    public static double acos(double value) {
        return Math.toDegrees(Math.acos(value));
    }

    /**
     * 反正切函数
     *
     * @param value 正切值
     * @return 角度
     */
    public static double atan(double value) {
        return Math.toDegrees(Math.atan(value));
    }

}
