/*
 *
 *
 *
 */
package cn.gongler.util.function;

import java.util.Objects;
import java.util.function.Function;

/**
 * @param <T> T
 * @param <U> U
 * @param <W> W
 * @param <R> result
 * @author gongler
 */
@FunctionalInterface
public interface TriFunction<T, U, W, R> {

    R apply(T t, U u, W w);

    default <V> TriFunction<T, U, W, V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (T t, U u, W w) -> after.apply(apply(t, u, w));
    }
}
