/*
 *
 *
 *
 */
package cn.gongler.util.function;

import java.util.Objects;

/**
 * @param <T> T
 * @param <U> U
 * @param <W> W
 * @author gongler
 */
@FunctionalInterface
public interface TriConsumer<T, U, W> extends ExceptionTriConsumer<T, U, W> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param t the first input argument
     * @param u the second input argument
     */
    @Override
    void accept(T t, U u, W w);

    @Override
    default ExceptionTriConsumer<T, U, W> acceptThen(T t, U u, W w) {//20160913add
        accept(t, u, w);
        return this;
    }

    /**
     * Returns a composed {@code BiConsumer} that performs, in sequence, this
     * operation followed by the {@code after} operation. If performing either
     * operation throws an exception, it is relayed to the caller of the
     * composed operation. If performing this operation throws an exception, the
     * {@code after} operation will not be performed.
     *
     * @param after the operation to perform after this operation
     * @return a composed {@code BiConsumer} that performs in sequence this
     * operation followed by the {@code after} operation
     * @throws NullPointerException if {@code after} is null
     */
    default TriConsumer<T, U, W> andThen(TriConsumer<? super T, ? super U, ? super W> after) {
        Objects.requireNonNull(after);

        return (l, r, w) -> {
            accept(l, r, w);
            after.accept(l, r, w);
        };
    }
}
