/*
 *
 *
 *
 */
package cn.gongler.util.function;

import java.util.Objects;
import java.util.function.Function;

/**
 * （实验类，不保证不会被改名和删除） 可以自动处理null的多级方法调用，省去了不断的null判断。 例：
 * <pre>
 *  int ret = NullableFunction.of(String::trim).then(Integer::decode).then(a to a * a).apply(null, -1);
 * </pre>
 *
 * @param <T> T
 * @param <R> result
 * @author gongler
 * @since 2016.8.2
 */
public interface NullableFunction<T, R> extends Function<T, R> {

    static <T1, R1> NullableFunction<T1, R1> of(NullableFunction<T1, R1> map) {
        NullableFunction<T1, T1> headMapper = a -> a;//通过隐含添加headMapper，确保允许参数为null时，不报空指针异常。
        return headMapper.then(map);
    }

    default <V> NullableFunction<T, V> then(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (T t) -> {
            if (t == null) {
                return (V) null;
            }
            R r = apply(t);
            if (r == null) {
                return (V) null;
            }
            return after.apply(r);
        };
    }

    default <V> NullableFunction<V, R> before(Function<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return (V v) -> {
            if (v == null) {
                return (R) null;
            }
            T t = before.apply(v);
            if (t == null) {
                return (R) null;
            }
            return apply(t);
        };
    }

    default R apply(T t, R defaultVal) {
        if (t == null) {
            return defaultVal;
        }
        R ret = apply(t);
        if (ret == null) {
            return defaultVal;
        } else {
            return ret;
        }
    }

    @Deprecated
    @Override
    default <V> NullableFunction<T, V> andThen(Function<? super R, ? extends V> after) {
        return then(after);
    }

    /**
     * 覆盖Function的compose()方法
     *
     * @param before the function to apply before this function is applied
     * @return 返回
     */
    @Deprecated
    @Override
    default <V> NullableFunction<V, R> compose(Function<? super V, ? extends T> before) {
        return before(before);
    }

}
