/*
 *
 *
 *
 */
package cn.gongler.util.function;

import java.util.Objects;
import java.util.function.IntConsumer;

import static cn.gongler.util.GonglerUtil.ExecuteWithThrowAny;

/**
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionIntConsumer {

    /**
     * Performs this operation on the given argument.
     *
     * @param value the input argument
     * @throws java.lang.Exception Exception
     */
    void accept(int value) throws Exception;

    /**
     * Returns a composed {@code IntConsumer} that performs, in sequence, this
     * operation followed by the {@code after} operation. If performing either
     * operation throws an exception, it is relayed to the caller of the
     * composed operation. If performing this operation throws an exception, the
     * {@code after} operation will not be performed.
     *
     * @param after the operation to perform after this operation
     * @return a composed {@code IntConsumer} that performs in sequence this
     * operation followed by the {@code after} operation
     * @throws NullPointerException if {@code after} is null
     */
    default ExceptionIntConsumer andThen(ExceptionIntConsumer after) {
        Objects.requireNonNull(after);
        return t -> {
            accept(t);
            after.accept(t);
        };
    }

    default IntConsumer toIntConsumer() {
        return t -> ExecuteWithThrowAny(() -> accept(t));
    }

}
