/*
 *
 *
 *
 */
package cn.gongler.util.function;

import cn.gongler.util.GonglerUtil;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * @param <T> T
 * @param <U> U
 * @param <R> R
 * @author gongler
 */
@FunctionalInterface
public interface ExceptionBiFunction<T, U, R> {

    R apply(T t, U u) throws Exception;

    default <V> ExceptionBiFunction<T, U, V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (T t, U u) -> after.apply(apply(t, u));
    }

    default R applyWithThrowAny(T t, U u) {
        return GonglerUtil.CallWithThrowAny(() -> apply(t, u));
    }

    default R applyWithCatchAny(T t, U u) {
        return applyWithCatchAny(t, u, null);
    }

    default R applyWithCatchAny(T t, U u, R defaultVal) {
        return GonglerUtil.CallWithCatchAny(() -> this.apply(t, u), defaultVal);
    }

    default BiFunction<T, U, R> toBiFunction() {
        return (t, u) -> GonglerUtil.CallWithThrowAny(() -> this.apply(t, u));
    }

}
