/*
 *
 *
 *
 */
package cn.gongler.util.db;

import cn.gongler.util.function.ExceptionConsumer;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import static cn.gongler.util.GonglerUtil.*;

/**
 * @author gongler
 * @since 2016.08.01
 */
@FunctionalInterface
public interface ConnectionFactory extends ExceptionConsumer<IDbTask> {

    Connection getConnection() throws SQLException;

    static ConnectionFactory of(String url, String user, String password) {
        return () -> DriverManager.getConnection(url, user, password);
    }

    static ConnectionFactory of(String url, java.util.Properties info) {
        return () -> DriverManager.getConnection(url, info);
    }

    static ConnectionFactory of(DataSource ds) {
        return ds::getConnection;
    }

    default DataSource toDataSource() {
        return DataSourceAdapter.of(this);
    }

    @Override
    default void accept(IDbTask task) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            task.accessDb(conn);
            Commit(conn);
        } catch (Exception e) {
            Rollback(conn);
            throw toRuntimeException(e);
        } finally {
            Close(conn);
        }
    }

}
