/*
 *
 *
 *
 */
package cn.gongler.util.concurrent;

import cn.gongler.util.db.ConnectionFactory;
import cn.gongler.util.db.IDbTask;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Consumer;

import static cn.gongler.util.GonglerUtil.ExecuteWithCatchAny;
import static cn.gongler.util.GonglerUtil.Rollback;

/**
 * @author gongler
 * @since 2016.08.01
 */
public class ConcurrentBusDbExecutor extends ConcurrentBusExecutor {

    private static final long serialVersionUID = 3106825658808470874L;//ConcurrentBusDbExecutor @since 2016-09-12
    private final ConnectionFactory connectionFactory;
    private Consumer<SQLException> sqlExceptionHandler = e -> {
    };

    /**
     * @param nThread           线程数
     * @param connectionFactory 由于会频繁获取连接，要求使用数据库连接池
     */
    public ConcurrentBusDbExecutor(int nThread, ConnectionFactory connectionFactory) {
        super(nThread);
        this.connectionFactory = connectionFactory;
    }

    private long milliseconds = Duration.ofMinutes(10).toMillis();

    public ConcurrentBusDbExecutor timeout(Duration timeout) {
        this.milliseconds = timeout.toMillis();
        return this;
    }

    private Connection withTimeout(Connection conn) {//gongler20190711add
        try {
            if (conn.getNetworkTimeout() <= 0L) {
                conn.setNetworkTimeout(Runnable::run, (int) milliseconds);
            }
        } catch (SQLException ex) {
        }
        return conn;
    }

    /**
     * @param nThread    线程数
     * @param dataSource 由于会频繁获取连接，要求使用数据库连接池
     */
    public ConcurrentBusDbExecutor(int nThread, DataSource dataSource) {
        this(nThread, dataSource::getConnection);
    }

    public ConcurrentBusDbExecutor sqlExceptionHandler(Consumer<SQLException> sqlExceptionHandler) {//20160801数据库异常统一处理
        this.sqlExceptionHandler = sqlExceptionHandler;
        return this;
    }

    public void accept(Long busKey, IDbTask dbTask) {
        accept(busKey, () -> {
            Connection conn2 = null;
            try (Connection conn = conn2 = connectionFactory.getConnection()) {
                dbTask.accessDb(withTimeout(conn));
                conn.commit();
            } catch (Throwable ex) {
                ex.printStackTrace();
                Rollback(conn2);//由于连接池中的Connection.close()并没有真正关闭，也就是数据库驱动是不可知的，没有机会回滚。因此，在此强制回滚。
                if (ex instanceof SQLException) {
                    ExecuteWithCatchAny(() -> sqlExceptionHandler.accept((SQLException) ex));
                }
            }
        });
    }

//    @Override
//    public String toString(){
//        return super.toString();
//    }
//
}
