/*
 *
 *
 *
 */
package cn.gongler.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author gongler
 */
class CloseRegister implements AutoCloseable {

    private static final long serialVersionUID = 1L;

    final List<Runnable> tasks = new ArrayList<>();

    public static CloseRegister of() {
        return new CloseRegister();
    }

    public static CloseRegister of(Runnable... tasks) {
        //System.out.println("End.of()");
        return new CloseRegister().addAll(tasks);
    }

    public CloseRegister addAll(Runnable... tasks) {
        this.tasks.addAll(Arrays.asList(tasks));
        return this;
    }

    public CloseRegister add(Runnable task) {
        this.tasks.add(task);
        return this;
    }

    @Override
    public void close() throws Exception {
        List<Runnable> dest = new ArrayList<>(tasks);
        Collections.reverse(dest);
        for (Runnable task : dest) {
            try {
                task.run();
            } catch (Throwable e) {
                //关闭资源时没必要报错 e.printStackTrace();
            }
        }
    }

}
