package cn.gongler.util.collection;

import cn.gongler.util.annotation.Unstable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author honger
 * date 2022/10/26
 */
@Unstable
public class ListFluent<E> {

    private static final long serialVersionUID = 1L;

    private final List<E> list;

    public ListFluent(List<E> list) {
        this.list = list;
    }

    public static <E> ListFluent of(List<E> map) {
        return new ListFluent(map);
    }

    public static <E> ListFluent<E> of() {
        return new ListFluent<>(new ArrayList<>());
    }

    public ListFluent<E> add(E e) {
        list.add(e);
        return this;
    }

    public List<E> result() {
        return list;
    }

    public void forEach(Consumer<? super E> action) {
        list.forEach(action);
    }

    public String toString() {
        return list.toString();
    }

}
