/**
 * 字节数组相关的读取和生成
 * <ul>
 * <li>BytesBuilder: 生成字节数组或HEX字符串，支持不满1字节的二进制写入</li>
 * <li>BytesLoader: 从字节数组中载入整数、字符串、等。支持不满1字节的二进制位读取</li>
 * <li>Bits: 便利的按1个或多个二进制位进行读写数操作。</li>
 * <li>HexUtil:对字节数组与HEX字符串间的转换</li>
 * </ul>
 *
 * <blockquote><pre>
 *     byte[] buf = BytesBuilder.of()
 *         .addNum(3, 0x123456)
 *         .addBytes("0102010A0F")
 *         .addBcd(2, 1234)
 *         .addBit(0)
 *         .addBit(1)
 *         .addBits(6, 2).toBytes();
 * </pre></blockquote>
 *
 * <blockquote><pre>
 *     String hex = BytesBuilder.of()
 *         .addNum(3, 0x123456)
 *         .addBytes("0102010A0F")
 *         .addBcd(2, 1234)
 *         .addBit(0)
 *         .addBit(1)
 *         .addBits(6, 2).toHex();
 * </pre></blockquote>
 * Version alpha
 *
 * @since 3.0.10
 */
package cn.gongler.util.bytes;