package cn.gongler.util.bytes;

import java.util.function.Supplier;

import static cn.gongler.util.bytes.HexUtil.BytesToHex;

/**
 * @author honger
 * @date 2022/10/6
 */

class SimpleByteArrayRange implements IBytesRange {
    private static final long serialVersionUID = 1L;

    public static SimpleByteArrayRange of(Supplier<byte[]> buf, int from, int size) {
        SimpleByteArrayRange ins = new SimpleByteArrayRange();
        ins.buf = buf;
        ins.size = size;
        ins.from = from;
        return ins;
    }

    Supplier<byte[]> buf;
    int from;
    int size;

    @Override
    public byte[] buf() {
        return buf.get();
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public int from() {
        return from;
    }

    public String toString() {
        return BytesToHex(buf(), from, size());
    }
}
