package cn.gongler.util.bytes;

import cn.gongler.util.bytes.function.IntByteConsumer;
import cn.gongler.util.bytes.function.IntByteOperator;
import cn.gongler.util.bytes.function.LongByteOperator;

import java.io.InputStream;
import java.util.function.IntUnaryOperator;

/**
 * @author honger
 * @since 3.1
 */

public class Bytes {
    private static final long serialVersionUID = 1L;

    private Bytes() {
    }

    public final static byte[] EMPTY_BYTES = new byte[0];

    public static byte[] byteArray(String hex) {//2022年10月7日
        return BytesBuilder.of().addBytes(hex).toBytes();
    }

    public static byte[] byteArray(InputStream in) {//2022年10月7日
        return BytesBuilder.of().addByteStream(in).toBytes();
    }

    public static byte[] byteArray(int times, IntUnaryOperator mapper) {//2022年10月7日
        byte[] buf = new byte[times];
        for (int i = 0; i < times; i++) {
            buf[i] = (byte) mapper.applyAsInt(i);
        }
        return buf;
    }

    public static byte[] fillArray(byte[] buf, int from, int times, IntUnaryOperator mapper) {//2022年10月7日
        for (int i = 0; i < times; i++) {
            buf[from + i] = (byte) mapper.applyAsInt(i);
        }
        return buf;
    }

    public static byte[] forEach(byte[] buf, IntByteConsumer consumer) {//2022年10月7日
        for (int i = 0; i < buf.length; i++) {
            consumer.accept(i, buf[i] & 0xFF);
        }
        return buf;
    }

    public static int toIntResult(byte[] buf, int beginVal, IntByteOperator mapper) {//2022年10月7日
        return toIntResult(buf, 0, buf.length, beginVal, mapper);
    }

    public static int toIntResult(byte[] buf, int from, int byteCnt, int beginVal, IntByteOperator mapper) {//2022年10月7日
        int ret = beginVal;
        for (int i = 0; i < byteCnt; i++) {
            ret = (byte) mapper.apply(ret, buf[from + i] & 0xFF);
        }
        return ret;
    }

    public static long toLongResult(byte[] buf, long beginVal, LongByteOperator mapper) {//2022年10月7日
        long ret = beginVal;
        for (byte b : buf) {
            ret = (byte) mapper.apply(ret, b & 0xFF);
        }
        return ret;
    }

    public static String toString(byte[] buf) {
        return toString(buf, "");
    }

    public static String toString(byte[] buf, CharSequence delimiter) {
        return HexUtil.BytesToHex(buf, delimiter);
    }

    public static String toString(byte[] buf, int from, int size) {
        return toString(buf, from, size, "");
    }

    public static String toString(byte[] buf, int from, int size, CharSequence delimiter) {
        return HexUtil.BytesToHex(buf, from, size, delimiter);
    }

    public static String toString(IBytesRange bytesRange) {
        return toString(bytesRange, "");
    }

    public static String toString(IBytesRange bytesRange, CharSequence delimiter) {
        return HexUtil.BytesToHex(bytesRange, delimiter);
    }

}
