/*
 * PROJECT: gonglerutils
 * DESCRIPTION:
 * USER: gongler
 * DATE: 2022-03-04
 */
package cn.gongler.util.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.SOURCE;

/**
 * 用来标注代码品质稳定前的前期阶段。这个阶段的代码可能会变化或删除。
 *
 * @author gongler
 */
@Documented
@Target({TYPE, METHOD})
@Inherited
@Retention(SOURCE)
public @interface Unstable {
}
